#include "tool_setup.h"
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Apr 20 08:58:30 2018
 */
#ifdef USE_MANUAL
#include "tool_hugehelp.h"
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _\n"
"  Project                     ___| | | |  _ \\| |\n"
"                             / __| | | | |_) | |\n"
"                            | (__| |_| |  _ <| |___\n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl  is  a tool to transfer data from or to a server, using one of the\n"
"       supported protocols (DICT, FILE, FTP, FTPS, GOPHER, HTTP, HTTPS,  IMAP,\n"
, stdout);
 fputs(
"       IMAPS,  LDAP,  LDAPS,  POP3, POP3S, RTMP, RTSP, SCP, SFTP, SMTP, SMTPS,\n"
"       TELNET and TFTP).  The command is designed to work without user  inter-\n"
"       action.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support, user authen-\n"
"       tication, FTP upload, HTTP post, SSL connections, cookies, file  trans-\n"
"       fer  resume,  Metalink,  and more. As you will see below, the number of\n"
"       features will make your head spin!\n"
"\n"
, stdout);
 fputs(
"       curl is powered by  libcurl  for  all  transfer-related  features.  See\n"
"       libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax is protocol-dependent. You'll find a detailed descrip-\n"
"       tion in RFC 3986.\n"
"\n"
"       You can specify multiple URLs or parts of URLs  by  writing  part  sets\n"
"       within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or you can get sequences of alphanumeric series by using [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
, stdout);
 fputs(
"        ftp://ftp.numericals.com/file[001-100].txt    (with leading zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       Nested  sequences  are not supported, but you can use several ones next\n"
"       to each other:\n"
"\n"
"        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\n"
"\n"
"       You can specify any amount of URLs on the command line.  They  will  be\n"
"       fetched in a sequential manner in the specified order.\n"
"\n"
, stdout);
 fputs(
"       You  can  specify a step counter for the ranges to get every Nth number\n"
"       or letter:\n"
"\n"
"        http://www.numericals.com/file[1-100:10].txt\n"
"        http://www.letters.com/file[a-z:2].txt\n"
"\n"
"       If you specify URL without protocol:// prefix,  curl  will  attempt  to\n"
"       guess  what  protocol  you might want. It will then default to HTTP but\n"
"       try other protocols based on often-used host name prefixes.  For  exam-\n"
, stdout);
 fputs(
"       ple,  for  host names starting with \"ftp.\" curl will assume you want to\n"
"       speak FTP.\n"
"\n"
"       curl will do its best to use what you pass to it as a URL.  It  is  not\n"
"       trying  to  validate it as a syntactically correct URL by any means but\n"
"       is instead very liberal with what it accepts.\n"
"\n"
"       curl will attempt to re-use connections for multiple file transfers, so\n"
"       that  getting many files from the same server will not do multiple con-\n"
, stdout);
 fputs(
"       nects / handshakes. This improves speed. Of course this is only done on\n"
"       files  specified  on  a  single command line and cannot be used between\n"
"       separate curl invokes.\n"
"\n"
"PROGRESS METER\n"
"       curl normally displays a progress meter during  operations,  indicating\n"
"       the  amount  of  transferred  data,  transfer speeds and estimated time\n"
"       left, etc.\n"
"\n"
"       curl displays this data to the terminal by default, so  if  you  invoke\n"
, stdout);
 fputs(
"       curl  to do an operation and it is about to write data to the terminal,\n"
"       it disables the progress meter as otherwise it would mess up the output\n"
"       mixing progress meter and response data.\n"
"\n"
"       If you want a progress meter for HTTP POST or PUT requests, you need to\n"
"       redirect the response output to a file, using shell  redirect  (>),  -o\n"
"       [file] or similar.\n"
"\n"
"       It  is not the same case for FTP upload as that operation does not spit\n"
, stdout);
 fputs(
"       out any response data to the terminal.\n"
"\n"
"       If you prefer a progress \"bar\" instead of the regular meter, -# is your\n"
"       friend.\n"
"OPTIONS\n"
"       In general, all boolean options are enabled with --option and yet again\n"
"       disabled with --no-option. That is, you use the exact same option  name\n"
"       but prefix it with \"no-\". However, in this list we mostly only list and\n"
"       show the --option version of them. (This concept with --no options  was\n"
, stdout);
 fputs(
"       added  in  7.19.0.  Previously  most  options  were  toggled  on/off on\n"
"       repeated use of the same command line option.)\n"
"\n"
"       -#, --progress-bar\n"
"              Make curl display progress as a simple progress bar  instead  of\n"
"              the standard, more informational, meter.\n"
"\n"
"       -0, --http1.0\n"
"              (HTTP)  Forces curl to issue its requests using HTTP 1.0 instead\n"
"              of using its internally preferred: HTTP 1.1.\n"
"\n"
"       -1, --tlsv1\n"
, stdout);
 fputs(
"              (SSL) Forces curl to use TLS version 1 when negotiating  with  a\n"
"              remote TLS server.\n"
"\n"
"       -2, --sslv2\n"
"              (SSL)  Forces  curl to use SSL version 2 when negotiating with a\n"
"              remote SSL server.\n"
"\n"
"       -3, --sslv3\n"
"              (SSL) Forces curl to use SSL version 3 when negotiating  with  a\n"
"              remote SSL server.\n"
"\n"
"       -4, --ipv4\n"
"              If  curl  is capable of resolving an address to multiple IP ver-\n"
, stdout);
 fputs(
"              sions (which it is if it is  IPv6-capable),  this  option  tells\n"
"              curl to resolve names to IPv4 addresses only.\n"
"\n"
"       -6, --ipv6\n"
"              If  curl  is capable of resolving an address to multiple IP ver-\n"
"              sions (which it is if it is  IPv6-capable),  this  option  tells\n"
"              curl to resolve names to IPv6 addresses only.\n"
"\n"
"       -a, --append\n"
"              (FTP/SFTP) When used in an upload, this will tell curl to append\n"
, stdout);
 fputs(
"              to the target file  instead  of  overwriting  it.  If  the  file\n"
"              doesn't  exist,  it  will  be  created.   Note that this flag is\n"
"              ignored by some SSH servers (including OpenSSH).\n"
"\n"
"       -A, --user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the HTTP server.\n"
"              Some   badly   done  CGIs  fail  if  this  field  isn't  set  to\n"
"              \"Mozilla/4.0\". To encode blanks  in  the  string,  surround  the\n"
, stdout);
 fputs(
"              string  with  single  quote marks. This can also be set with the\n"
"              -H, --header option of course.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --anyauth\n"
"              (HTTP) Tells curl to figure out authentication method by itself,\n"
"              and  use  the most secure one the remote site claims to support.\n"
"              This is done by first doing a request and checking the response-\n"
, stdout);
 fputs(
"              headers,  thus  possibly  inducing  an extra network round-trip.\n"
"              This is  used  instead  of  setting  a  specific  authentication\n"
"              method,  which  you  can  do with --basic, --digest, --ntlm, and\n"
"              --negotiate.\n"
"\n"
"              Note that using --anyauth is not recommended if you  do  uploads\n"
"              from  stdin, since it may require data to be sent twice and then\n"
, stdout);
 fputs(
"              the client must be able to rewind. If the need should arise when\n"
"              uploading from stdin, the upload operation will fail.\n"
"\n"
"       -b, --cookie <name=data>\n"
"              (HTTP)  Pass the data to the HTTP server as a cookie. It is sup-\n"
"              posedly the data previously received from the server in a  \"Set-\n"
"              Cookie:\"  line.  The data should be in the format \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
, stdout);
 fputs(
"              If no '=' symbol is used in the line, it is treated as  a  file-\n"
"              name  to  use to read previously stored cookie lines from, which\n"
"              should be used in this session if they match. Using this  method\n"
"              also  activates  the \"cookie parser\" which will make curl record\n"
"              incoming cookies too, which may be handy if you're using this in\n"
"              combination  with  the -L, --location option. The file format of\n"
, stdout);
 fputs(
"              the file to read cookies from should be plain  HTTP  headers  or\n"
"              the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE  that  the file specified with -b, --cookie is only used as\n"
"              input. No cookies will be stored in the file. To store  cookies,\n"
"              use  the -c, --cookie-jar option or you could even save the HTTP\n"
"              headers to a file using -D, --dump-header!\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -B, --use-ascii\n"
"              (FTP/LDAP) Enable ASCII transfer. For  FTP,  this  can  also  be\n"
"              enforced  by  using an URL that ends with \";type=A\". This option\n"
"              causes data sent to stdout to be in text mode for win32 systems.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication. This is  the\n"
, stdout);
 fputs(
"              default  and this option is usually pointless, unless you use it\n"
"              to override a  previously  set  option  that  sets  a  different\n"
"              authentication  method  (such  as --ntlm, --digest, or --negoti-\n"
"              ate).\n"
"\n"
"       -c, --cookie-jar <file name>\n"
"              (HTTP) Specify to which file you want curl to write all  cookies\n"
"              after  a completed operation. Curl writes all cookies previously\n"
, stdout);
 fputs(
"              read from a specified file as well as all cookies received  from\n"
"              remote server(s). If no cookies are known, no file will be writ-\n"
"              ten. The file will be written using  the  Netscape  cookie  file\n"
"              format.  If  you  set  the  file name to a single dash, \"-\", the\n"
"              cookies will be written to stdout.\n"
"\n"
"              This command line option will activate the  cookie  engine  that\n"
, stdout);
 fputs(
"              makes curl record and use cookies. Another way to activate it is\n"
"              to use the -b, --cookie option.\n"
"\n"
"              If the cookie jar can't be created or written to, the whole curl\n"
"              operation  won't  fail or even report an error clearly. Using -v\n"
"              will get a warning displayed, but that is the only visible feed-\n"
"              back you get about this possibly lethal situation.\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is used several times, the last specified file\n"
"              name will be used.\n"
"\n"
"       -C, --continue-at <offset>\n"
"              Continue/Resume a previous file transfer at  the  given  offset.\n"
"              The  given  offset  is  the  exact  number of bytes that will be\n"
"              skipped, counting from the beginning of the source  file  before\n"
"              it is transferred to the destination.  If used with uploads, the\n"
, stdout);
 fputs(
"              FTP server command SIZE will not be used by curl.\n"
"\n"
"              Use \"-C -\" to tell curl to automatically find out  where/how  to\n"
"              resume  the  transfer. It then uses the given output/input files\n"
"              to figure that out.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connection. The list\n"
, stdout);
 fputs(
"              of  ciphers  must  specify  valid ciphers. Read up on SSL cipher\n"
"              list          details           on           this           URL:\n"
"              http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              NSS  ciphers  are  done differently than OpenSSL and GnuTLS. The\n"
"              full list of NSS ciphers is in the NSSCipherSuite entry at  this\n"
"              URL:                                          http://git.fedora-\n"
, stdout);
 fputs(
"              hosted.org/cgit/mod_nss.git/plain/docs/mod_nss.html#Directives\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using one of the algorithms\n"
"              curl  supports,  and  save  the  uncompressed document.  If this\n"
"              option is used and the server  sends  an  unsupported  encoding,\n"
"              curl will report an error.\n"
"\n"
"       --connect-timeout <seconds>\n"
, stdout);
 fputs(
"              Maximum  time  in  seconds  that you allow the connection to the\n"
"              server to take.  This only limits  the  connection  phase,  once\n"
"              curl  has  connected this option is of no more use. See also the\n"
"              -m, --max-time option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --create-dirs\n"
"              When used in conjunction with the -o option,  curl  will  create\n"
, stdout);
 fputs(
"              the  necessary  local directory hierarchy as needed. This option\n"
"              creates the dirs mentioned with the -o option, nothing else.  If\n"
"              the  -o file name uses no dir or if the dirs it mentions already\n"
"              exist, no dir will be created.\n"
"\n"
"              To create remote directories when using FTP or SFTP, try  --ftp-\n"
"              create-dirs.\n"
"\n"
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for MVS (OS/390).\n"
"\n"
"       --crlfile <file>\n"
, stdout);
 fputs(
"              (HTTPS/FTPS)  Provide a file using PEM format with a Certificate\n"
"              Revocation List that may specify peer certificates that  are  to\n"
"              be considered revoked.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              (Added in 7.19.7)\n"
"       -d, --data <data>\n"
"              (HTTP)  Sends  the  specified data in a POST request to the HTTP\n"
"              server, in the same way that a browser  does  when  a  user  has\n"
, stdout);
 fputs(
"              filled  in an HTML form and presses the submit button. This will\n"
"              cause curl to pass the data to the server using the content-type\n"
"              application/x-www-form-urlencoded.  Compare to -F, --form.\n"
"\n"
"              -d,  --data  is  the  same  as --data-ascii. To post data purely\n"
"              binary, you should instead use the --data-binary option. To URL-\n"
"              encode the value of a form field you may use --data-urlencode.\n"
"\n"
, stdout);
 fputs(
"              If  any of these options is used more than once on the same com-\n"
"              mand line, the data pieces specified  will  be  merged  together\n"
"              with  a  separating  &-symbol.  Thus,  using  '-d name=daniel -d\n"
"              skill=lousy'  would  generate  a  post  chunk  that  looks  like\n"
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
, stdout);
 fputs(
"              file name to read the data from, or - if you want curl  to  read\n"
"              the  data  from stdin.  The contents of the file must already be\n"
"              URL-encoded. Multiple files can also be specified. Posting  data\n"
"              from  a file named 'foobar' would thus be done with --data @foo-\n"
"              bar.\n"
"\n"
"       -D, --dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
, stdout);
 fputs(
"              This option is handy to use when you want to store  the  headers\n"
"              that  an  HTTP site sends to you. Cookies from the headers could\n"
"              then be read in a  second  curl  invocation  by  using  the  -b,\n"
"              --cookie option! The -c, --cookie-jar option is however a better\n"
"              way to store cookies.\n"
"\n"
"              When used in FTP, the FTP server response lines  are  considered\n"
"              being \"headers\" and thus are saved there.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --data-ascii <data>\n"
"              See -d, --data.\n"
"\n"
"       --data-binary <data>\n"
"              (HTTP)  This  posts data exactly as specified with no extra pro-\n"
"              cessing whatsoever.\n"
"\n"
"              If you start the data with the letter @, the rest  should  be  a\n"
"              filename.   Data  is  posted in a similar manner as --data-ascii\n"
, stdout);
 fputs(
"              does, except that newlines are  preserved  and  conversions  are\n"
"              never done.\n"
"\n"
"              If  this  option  is  used several times, the ones following the\n"
"              first will append data as described in -d, --data.\n"
"\n"
"       --data-urlencode <data>\n"
"              (HTTP) This posts data, similar to the other --data options with\n"
"              the exception that this performs URL-encoding. (Added in 7.18.0)\n"
, stdout);
 fputs(
"              To  be  CGI-compliant,  the <data> part should begin with a name\n"
"              followed by a separator and a content specification. The  <data>\n"
"              part can be passed to curl using one of the following syntaxes:\n"
"\n"
"              content\n"
"                     This  will make curl URL-encode the content and pass that\n"
"                     on. Just be careful so that the content  doesn't  contain\n"
"                     any  =  or  @  symbols, as that will then make the syntax\n"
, stdout);
 fputs(
"                     match one of the other cases below!\n"
"\n"
"              =content\n"
"                     This will make curl URL-encode the content and pass  that\n"
"                     on. The preceding = symbol is not included in the data.\n"
"\n"
"              name=content\n"
"                     This  will make curl URL-encode the content part and pass\n"
"                     that on. Note that the name part is expected to  be  URL-\n"
"                     encoded already.\n"
"\n"
"              @filename\n"
, stdout);
 fputs(
"                     This  will  make  curl  load  data  from  the  given file\n"
"                     (including any newlines), URL-encode that data  and  pass\n"
"                     it on in the POST.\n"
"\n"
"              name@filename\n"
"                     This  will  make  curl  load  data  from  the  given file\n"
"                     (including any newlines), URL-encode that data  and  pass\n"
"                     it  on  in  the  POST.  The  name part gets an equal sign\n"
, stdout);
 fputs(
"                     appended, resulting in name=urlencoded-file-content. Note\n"
"                     that the name is expected to be URL-encoded already.\n"
"\n"
"       --delegation LEVEL\n"
"              Set LEVEL to tell the server what it is allowed to delegate when\n"
"              it comes to user credentials. Used with GSS/kerberos.\n"
"\n"
"              none   Don't allow any delegation.\n"
"\n"
"              policy Delegates if and only if the OK-AS-DELEGATE flag  is  set\n"
, stdout);
 fputs(
"                     in  the  Kerberos  service  ticket,  which is a matter of\n"
"                     realm policy.\n"
"\n"
"              always Unconditionally allow the server to delegate.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This is an  authenti-\n"
"              cation  scheme  that  prevents the password from being sent over\n"
"              the wire in clear text. Use this in combination with the  normal\n"
, stdout);
 fputs(
"              -u,  --user  option  to  set  user  name  and password. See also\n"
"              --ntlm, --negotiate and --anyauth for related options.\n"
"\n"
"              If this option is used several times,  only  the  first  one  is\n"
"              used.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT and LPRT commands\n"
"              when doing active FTP transfers. Curl will normally always first\n"
, stdout);
 fputs(
"              attempt  to use EPRT, then LPRT before using PORT, but with this\n"
"              option, it will use PORT right away. EPRT and  LPRT  are  exten-\n"
"              sions  to  the  original  FTP  protocol, and may not work on all\n"
"              servers, but they enable more functionality in a better way than\n"
"              the traditional PORT command.\n"
"\n"
"              --eprt can be used to explicitly enable EPRT again and --no-eprt\n"
"              is an alias for --disable-eprt.\n"
"\n"
, stdout);
 fputs(
"              Disabling EPRT only changes the active behavior. If you want  to\n"
"              switch  to  passive  mode  you need to not use -P, --ftp-port or\n"
"              force it with --ftp-pasv.\n"
"\n"
"       --disable-epsv\n"
"              (FTP) Tell curl to disable the use  of  the  EPSV  command  when\n"
"              doing  passive  FTP  transfers.  Curl will normally always first\n"
"              attempt to use EPSV before PASV, but with this option,  it  will\n"
"              not try using EPSV.\n"
"\n"
, stdout);
 fputs(
"              --epsv can be used to explicitly enable EPSV again and --no-epsv\n"
"              is an alias for --disable-epsv.\n"
"\n"
"              Disabling EPSV only changes the passive behavior. If you want to\n"
"              switch to active mode you need to use -P, --ftp-port.\n"
"\n"
"       -e, --referer <URL>\n"
"              (HTTP)  Sends the \"Referer Page\" information to the HTTP server.\n"
"              This can also be set with the -H, --header flag of course.  When\n"
, stdout);
 fputs(
"              used with -L, --location you can append \";auto\" to the --referer\n"
"              URL to make curl automatically set the previous URL when it fol-\n"
"              lows  a  Location: header. The \";auto\" string can be used alone,\n"
"              even if you don't set an initial --referer.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -E, --cert <certificate[:password]>\n"
"              (SSL) Tells curl to use the specified  client  certificate  file\n"
, stdout);
 fputs(
"              when getting a file with HTTPS, FTPS or another SSL-based proto-\n"
"              col. The certificate must be in PEM  format.   If  the  optional\n"
"              password  isn't  specified, it will be queried for on the termi-\n"
"              nal. Note that this option assumes a \"certificate\" file that  is\n"
"              the  private  key  and the private certificate concatenated! See\n"
"              --cert and --key to specify them independently.\n"
"\n"
, stdout);
 fputs(
"              If curl is built against the NSS SSL library  then  this  option\n"
"              can  tell curl the nickname of the certificate to use within the\n"
"              NSS database defined by the environment variable SSL_DIR (or  by\n"
"              default  /etc/pki/nssdb).  If  the  NSS PEM PKCS#11 module (lib-\n"
"              nsspem.so) is available then PEM files may  be  loaded.  If  you\n"
"              want to use a file from the current directory, please precede it\n"
, stdout);
 fputs(
"              with \"./\" prefix, in order to avoid confusion with a nickname.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --engine <name>\n"
"              Select the OpenSSL crypto engine to use for  cipher  operations.\n"
"              Use  --engine  list  to  print  a  list  of build-time supported\n"
"              engines. Note that not all (or  none)  of  the  engines  may  be\n"
"              available at run-time.\n"
"\n"
"       --environment\n"
, stdout);
 fputs(
"              (RISC  OS ONLY) Sets a range of environment variables, using the\n"
"              names the -w option supports, to allow easier extraction of use-\n"
"              ful information after having run curl.\n"
"\n"
"       --egd-file <file>\n"
"              (SSL)  Specify  the  path  name  to the Entropy Gathering Daemon\n"
"              socket. The socket is used to seed the  random  engine  for  SSL\n"
"              connections. See also the --random-file option.\n"
"\n"
"       --cert-type <type>\n"
, stdout);
 fputs(
"              (SSL)  Tells curl what certificate type the provided certificate\n"
"              is in. PEM, DER and ENG are recognized types.  If not specified,\n"
"              PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
"              (SSL) Tells curl to use the specified certificate file to verify\n"
"              the peer. The file may contain  multiple  CA  certificates.  The\n"
, stdout);
 fputs(
"              certificate(s)  must be in PEM format. Normally curl is built to\n"
"              use a default file for this, so this option is typically used to\n"
"              alter that default file.\n"
"\n"
"              curl  recognizes the environment variable named 'CURL_CA_BUNDLE'\n"
"              if it is set, and uses the given path as a path  to  a  CA  cert\n"
"              bundle. This option overrides that variable.\n"
"\n"
"              The  windows  version  of  curl will automatically look for a CA\n"
, stdout);
 fputs(
"              certs file named 'curl-ca-bundle.crt', either in the same direc-\n"
"              tory as curl.exe, or in the Current Working Directory, or in any\n"
"              folder along your PATH.\n"
"\n"
"              If curl is built against  the  NSS  SSL  library,  the  NSS  PEM\n"
"              PKCS#11  module  (libnsspem.so)  needs  to be available for this\n"
"              option to work properly.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --capath <CA certificate directory>\n"
"              (SSL) Tells curl to use the specified certificate  directory  to\n"
"              verify  the  peer.  Multiple paths can be provided by separating\n"
"              them with \":\" (e.g.  \"path1:path2:path3\"). The certificates must\n"
"              be  in  PEM  format,  and  if curl is built against OpenSSL, the\n"
"              directory must have been processed using  the  c_rehash  utility\n"
, stdout);
 fputs(
"              supplied  with OpenSSL. Using --capath can allow OpenSSL-powered\n"
"              curl to make SSL-connections much more  efficiently  than  using\n"
"              --cacert if the --cacert file contains many CA certificates.\n"
"\n"
"              If this option is set, the default capath value will be ignored,\n"
"              and if it is used several times, the last one will be used.\n"
"\n"
"       -f, --fail\n"
"              (HTTP) Fail silently (no output at all) on server  errors.  This\n"
, stdout);
 fputs(
"              is  mostly done to better enable scripts etc to better deal with\n"
"              failed attempts. In normal cases when an HTTP  server  fails  to\n"
"              deliver  a  document,  it  returns  an  HTML document stating so\n"
"              (which often also describes why and more). This flag  will  pre-\n"
"              vent curl from outputting that and return error 22.\n"
"\n"
"              This  method is not fail-safe and there are occasions where non-\n"
, stdout);
 fputs(
"              successful response codes will  slip  through,  especially  when\n"
"              authentication is involved (response codes 401 and 407).\n"
"\n"
"       -F, --form <name=content>\n"
"              (HTTP)  This  lets curl emulate a filled-in form in which a user\n"
"              has pressed the submit button. This causes  curl  to  POST  data\n"
"              using  the  Content-Type  multipart/form-data  according  to RFC\n"
"              2388. This enables uploading of binary files etc. To  force  the\n"
, stdout);
 fputs(
"              'content'  part  to  be  a  file, prefix the file name with an @\n"
"              sign. To just get the content part from a file, prefix the  file\n"
"              name  with  the symbol <. The difference between @ and < is then\n"
"              that @ makes a file get attached in the post as a  file  upload,\n"
"              while  the  <  makes  a text field and just get the contents for\n"
"              that text field from a file.\n"
"\n"
, stdout);
 fputs(
"              Example, to send your password file to the server, where  'pass-\n"
"              word' is the name of the form-field to which /etc/passwd will be\n"
"              the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To read content from stdin instead of a file, use - as the file-\n"
"              name. This goes for both @ and < constructs.\n"
"\n"
"              You  can  also  tell  curl  what  Content-Type  to  use by using\n"
, stdout);
 fputs(
"              'type=', in a manner similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              or\n"
"\n"
"              curl -F \"name=daniel;type=text/foo\" url.com\n"
"\n"
"              You can also explicitly change the name field of a  file  upload\n"
"              part by setting filename=, like this:\n"
"\n"
"              curl -F \"file=@localfile;filename=nameinpost\" url.com\n"
"\n"
"              If  filename/path contains ',' or ';', it must be quoted by dou-\n"
"              ble-quotes like:\n"
, stdout);
 fputs(
"\n"
"              curl -F \"file=@\\\"localfile\\\";filename=\\\"nameinpost\\\"\" url.com\n"
"\n"
"              or\n"
"\n"
"              curl -F 'file=@\"localfile\";filename=\"nameinpost\"' url.com\n"
"\n"
"              Note that if a filename/path is  quoted  by  double-quotes,  any\n"
"              double-quote or backslash within the filename must be escaped by\n"
"              backslash.\n"
"\n"
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --ftp-account [data]\n"
, stdout);
 fputs(
"              (FTP) When an FTP server asks for \"account data\" after user name\n"
"              and  password has been provided, this data is sent off using the\n"
"              ACCT command. (Added in 7.13.0)\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --ftp-alternative-to-user <command>\n"
"              (FTP) If authenticating with the USER and PASS  commands  fails,\n"
"              send  this  command.   When  connecting  to  Tumbleweed's Secure\n"
, stdout);
 fputs(
"              Transport server over FTPS using  a  client  certificate,  using\n"
"              \"SITE  AUTH\"  will tell the server to retrieve the username from\n"
"              the certificate. (Added in 7.15.5)\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP/SFTP) When an FTP or SFTP URL/operation uses  a  path  that\n"
"              doesn't  currently exist on the server, the standard behavior of\n"
"              curl is to fail. Using this option, curl will instead attempt to\n"
, stdout);
 fputs(
"              create missing directories.\n"
"\n"
"       --ftp-method [method]\n"
"              (FTP)  Control what method curl should use to reach a file on an\n"
"              FTP(S) server. The method argument should be one of the  follow-\n"
"              ing alternatives:\n"
"\n"
"              multicwd\n"
"                     curl  does  a  single CWD operation for each path part in\n"
"                     the given URL. For deep hierarchies this means very  many\n"
, stdout);
 fputs(
"                     commands.  This  is  how RFC 1738 says it should be done.\n"
"                     This is the default but the slowest behavior.\n"
"\n"
"              nocwd  curl does no CWD at all. curl will do  SIZE,  RETR,  STOR\n"
"                     etc and give a full path to the server for all these com-\n"
"                     mands. This is the fastest behavior.\n"
"\n"
"              singlecwd\n"
"                     curl does one CWD with the full target directory and then\n"
, stdout);
 fputs(
"                     operates  on  the  file  \"normally\" (like in the multicwd\n"
"                     case). This is somewhat  more  standards  compliant  than\n"
"                     'nocwd' but without the full penalty of 'multicwd'.\n"
"       (Added in 7.15.1)\n"
"\n"
"       --ftp-pasv\n"
"              (FTP)  Use  passive mode for the data connection. Passive is the\n"
"              internal default behavior, but using this option can be used  to\n"
, stdout);
 fputs(
"              override a previous -P/-ftp-port option. (Added in 7.11.0)\n"
"\n"
"              If  this  option  is  used  several times, only the first one is\n"
"              used. Undoing an enforced passive really isn't  doable  but  you\n"
"              must then instead enforce the correct -P, --ftp-port again.\n"
"\n"
"              Passive mode means that curl will try the EPSV command first and\n"
"              then PASV, unless --disable-epsv is used.\n"
"\n"
"       --ftp-skip-pasv-ip\n"
, stdout);
 fputs(
"              (FTP) Tell curl to not use the IP address the server suggests in\n"
"              its  response to curl's PASV command when curl connects the data\n"
"              connection. Instead curl will re-use  the  same  IP  address  it\n"
"              already uses for the control connection. (Added in 7.14.2)\n"
"\n"
"              This  option has no effect if PORT, EPRT or EPSV is used instead\n"
"              of PASV.\n"
"\n"
"       --ftp-pret\n"
, stdout);
 fputs(
"              (FTP) Tell curl to send a PRET command before PASV  (and  EPSV).\n"
"              Certain  FTP  servers,  mainly drftpd, require this non-standard\n"
"              command for directory listings as well as up  and  downloads  in\n"
"              PASV mode.  (Added in 7.20.x)\n"
"\n"
"       --ftp-ssl-ccc\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Shuts down the SSL/TLS\n"
"              layer after authenticating. The rest of the control channel com-\n"
, stdout);
 fputs(
"              munication  will be unencrypted. This allows NAT routers to fol-\n"
"              low the FTP transaction. The default mode is passive. See --ftp-\n"
"              ssl-ccc-mode for other modes.  (Added in 7.16.1)\n"
"\n"
"       --ftp-ssl-ccc-mode [active/passive]\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Sets the CCC mode. The\n"
"              passive mode will not initiate the shutdown,  but  instead  wait\n"
, stdout);
 fputs(
"              for the server to do it, and will not reply to the shutdown from\n"
"              the server. The active mode initiates the shutdown and waits for\n"
"              a reply from the server.  (Added in 7.16.2)\n"
"\n"
"       --ftp-ssl-control\n"
"              (FTP)  Require  SSL/TLS  for  the FTP login, clear for transfer.\n"
"              Allows secure authentication, but non-encrypted  data  transfers\n"
"              for  efficiency.   Fails the transfer if the server doesn't sup-\n"
, stdout);
 fputs(
"              port SSL/TLS.  (Added in 7.16.0) that can still be used but will\n"
"              be removed in a future version.\n"
"\n"
"       --form-string <name=string>\n"
"              (HTTP)  Similar  to  --form except that the value string for the\n"
"              named parameter is used literally. Leading '@' and  '<'  charac-\n"
"              ters, and the ';type=' string in the value have no special mean-\n"
"              ing. Use this in preference to --form if there's any possibility\n"
, stdout);
 fputs(
"              that  the  string  value may accidentally trigger the '@' or '<'\n"
"              features of --form.\n"
"\n"
"       -g, --globoff\n"
"              This option switches off the \"URL globbing parser\". When you set\n"
"              this  option, you can specify URLs that contain the letters {}[]\n"
"              without having them being interpreted by curl itself. Note  that\n"
"              these  letters are not normal legal URL contents but they should\n"
, stdout);
 fputs(
"              be encoded according to the URI standard.\n"
"\n"
"       -G, --get\n"
"              When used, this option will make all  data  specified  with  -d,\n"
"              --data  or  --data-binary  to  be  used  in  an HTTP GET request\n"
"              instead of the POST request that otherwise would  be  used.  The\n"
"              data will be appended to the URL with a '?' separator.\n"
"\n"
"              If  used  in  combination with -I, the POST data will instead be\n"
, stdout);
 fputs(
"              appended to the URL with a HEAD request.\n"
"\n"
"              If this option is used several times,  only  the  first  one  is\n"
"              used.  This is because undoing a GET doesn't make sense, but you\n"
"              should then instead enforce the alternative method you prefer.\n"
"\n"
"       -H, --header <header>\n"
"              (HTTP) Extra header to use when getting  a  web  page.  You  may\n"
"              specify any number of extra headers. Note that if you should add\n"
, stdout);
 fputs(
"              a custom header that has the same name as one  of  the  internal\n"
"              ones  curl  would  use,  your externally set header will be used\n"
"              instead of the internal one. This allows you to make even trick-\n"
"              ier  stuff  than  curl would normally do. You should not replace\n"
"              internally set  headers  without  knowing  perfectly  well  what\n"
"              you're  doing. Remove an internal header by giving a replacement\n"
, stdout);
 fputs(
"              without content on the right  side  of  the  colon,  as  in:  -H\n"
"              \"Host:\".  If  you  send the custom header with no-value then its\n"
"              header must be terminated with a semicolon, such as  -H  \"X-Cus-\n"
"              tom-Header;\" to send \"X-Custom-Header:\".\n"
"\n"
"              curl  will  make  sure  that each header you add/replace is sent\n"
"              with the proper end-of-line marker, you should thus not add that\n"
, stdout);
 fputs(
"              as a part of the header content: do not add newlines or carriage\n"
"              returns, they will only mess things up for you.\n"
"\n"
"              See also the -A, --user-agent and -e, --referer options.\n"
"\n"
"              This option can be used  multiple  times  to  add/replace/remove\n"
"              multiple headers.\n"
"\n"
"       --hostpubmd5 <md5>\n"
"              (SCP/SFTP)  Pass  a string containing 32 hexadecimal digits. The\n"
, stdout);
 fputs(
"              string should be the 128 bit MD5 checksum of the  remote  host's\n"
"              public key, curl will refuse the connection with the host unless\n"
"              the md5sums match. (Added in 7.17.1)\n"
"\n"
"       --ignore-content-length\n"
"              (HTTP) Ignore the Content-Length header.  This  is  particularly\n"
"              useful  for servers running Apache 1.x, which will report incor-\n"
"              rect Content-Length for files larger than 2 gigabytes.\n"
"\n"
"       -i, --include\n"
, stdout);
 fputs(
"              (HTTP) Include the HTTP-header in the  output.  The  HTTP-header\n"
"              includes  things  like  server-name, date of the document, HTTP-\n"
"              version and more...\n"
"\n"
"       -I, --head\n"
"              (HTTP/FTP/FILE) Fetch the HTTP-header only! HTTP-servers feature\n"
"              the  command  HEAD which this uses to get nothing but the header\n"
"              of a document. When used on an FTP or FILE file,  curl  displays\n"
, stdout);
 fputs(
"              the file size and last modification time only.\n"
"\n"
"       --interface <name>\n"
"              Perform  an operation using a specified interface. You can enter\n"
"              interface name, IP address or host name. An example  could  look\n"
"              like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -j, --junk-session-cookies\n"
, stdout);
 fputs(
"              (HTTP) When curl is told to read cookies from a given file, this\n"
"              option will make it discard all  \"session  cookies\".  This  will\n"
"              basically  have  the same effect as if a new session is started.\n"
"              Typical browsers always discard  session  cookies  when  they're\n"
"              closed down.\n"
"\n"
"       -J, --remote-header-name\n"
"              (HTTP) This option tells the -O, --remote-name option to use the\n"
, stdout);
 fputs(
"              server-specified   Content-Disposition   filename   instead   of\n"
"              extracting a filename from the URL.\n"
"\n"
"       -k, --insecure\n"
"              (SSL)  This  option explicitly allows curl to perform \"insecure\"\n"
"              SSL connections and transfers. All SSL connections are attempted\n"
"              to  be  made secure by using the CA certificate bundle installed\n"
"              by default. This makes  all  connections  considered  \"insecure\"\n"
, stdout);
 fputs(
"              fail unless -k, --insecure is used.\n"
"\n"
"              See     this    online    resource    for    further    details:\n"
"              http://curl.haxx.se/docs/sslcerts.html\n"
"\n"
"       -K, --config <config file>\n"
"              Specify which config file to read curl arguments from. The  con-\n"
"              fig  file  is a text file in which command line arguments can be\n"
"              written which then will be used as if they were written  on  the\n"
, stdout);
 fputs(
"              actual command line. Options and their parameters must be speci-\n"
"              fied on the same config  file  line,  separated  by  whitespace,\n"
"              colon,  the equals sign or any combination thereof (however, the\n"
"              preferred separator is the equals sign). If the parameter is  to\n"
"              contain  whitespace,  the  parameter  must  be  enclosed  within\n"
"              quotes. Within double quotes, the following escape sequences are\n"
, stdout);
 fputs(
"              available:  \\\\, \\\", \\t, \\n, \\r and \\v. A backslash preceding any\n"
"              other letter is ignored. If the first column of a config line is\n"
"              a  '#' character, the rest of the line will be treated as a com-\n"
"              ment. Only write one option per  physical  line  in  the  config\n"
"              file.\n"
"\n"
"              Specify  the  filename  to -K, --config as '-' to make curl read\n"
"              the file from stdin.\n"
"\n"
, stdout);
 fputs(
"              Note that to be able to specify a URL in the  config  file,  you\n"
"              need  to  specify  it  using the --url option, and not by simply\n"
"              writing the URL on its own line. So, it could  look  similar  to\n"
"              this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
"              Long  option  names  can  optionally be given in the config file\n"
"              without the initial double dashes.\n"
"\n"
, stdout);
 fputs(
"              When curl is invoked, it always (unless -q is used) checks for a\n"
"              default  config  file  and  uses it if found. The default config\n"
"              file is checked for in the following places in this order:\n"
"\n"
"              1) curl tries to find the \"home dir\": It first  checks  for  the\n"
"              CURL_HOME and then the HOME environment variables. Failing that,\n"
"              it uses getpwuid() on UNIX-like systems (which returns the  home\n"
, stdout);
 fputs(
"              dir  given the current user in your system). On Windows, it then\n"
"              checks for the APPDATA variable, or as a last resort the '%USER-\n"
"              PROFILE%\\Application Data'.\n"
"\n"
"              2)  On  windows, if there is no _curlrc file in the home dir, it\n"
"              checks for one in the same dir the curl executable is placed. On\n"
"              UNIX-like  systems,  it will simply try to load .curlrc from the\n"
"              determined home dir.\n"
"\n"
, stdout);
 fputs(
"              # --- Example file ---\n"
"              # this is a comment\n"
"              url = \"curl.haxx.se\"\n"
"              output = \"curlhere.html\"\n"
"              user-agent = \"superagent/1.0\"\n"
"\n"
"              # and fetch another URL too\n"
"              url = \"curl.haxx.se/docs/manpage.html\"\n"
"              -O\n"
"              referer = \"http://nowhereatall.com/\"\n"
"              # --- End of example file ---\n"
"\n"
"              This option can be used multiple times to load  multiple  config\n"
"              files.\n"
"\n"
, stdout);
 fputs(
"       --keepalive-time <seconds>\n"
"              This  option  sets  the  time  a connection needs to remain idle\n"
"              before sending keepalive probes and the time between  individual\n"
"              keepalive probes. It is currently effective on operating systems\n"
"              offering  the  TCP_KEEPIDLE  and  TCP_KEEPINTVL  socket  options\n"
"              (meaning  Linux, recent AIX, HP-UX and more). This option has no\n"
"              effect if --no-keepalive is used. (Added in 7.18.0)\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"              If unspecified, the option defaults to 60 seconds.\n"
"\n"
"       --key <key>\n"
"              (SSL/SSH) Private key file name. Allows you to provide your pri-\n"
"              vate key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --key-type <type>\n"
"              (SSL) Private key file type. Specify which type your --key  pro-\n"
, stdout);
 fputs(
"              vided  private  key  is. DER, PEM, and ENG are supported. If not\n"
"              specified, PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --krb <level>\n"
"              (FTP) Enable Kerberos authentication and use. The level must  be\n"
"              entered and should be one of 'clear', 'safe', 'confidential', or\n"
"              'private'. Should you use a level that  is  not  one  of  these,\n"
, stdout);
 fputs(
"              'private' will instead be used.\n"
"\n"
"              This  option  requires  a library built with kerberos4 or GSSAPI\n"
"              (GSS-Negotiate) support. This is not very common. Use -V, --ver-\n"
"              sion to see if your curl supports it.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -l, --list-only\n"
"              (FTP)  When listing an FTP directory, this switch forces a name-\n"
, stdout);
 fputs(
"              only view.  Especially useful if you want to  machine-parse  the\n"
"              contents  of  an  FTP  directory since the normal directory view\n"
"              doesn't use a standard look or format.\n"
"\n"
"              This option causes an FTP NLST command to  be  sent.   Some  FTP\n"
"              servers  list  only files in their response to NLST; they do not\n"
"              include subdirectories and symbolic links.\n"
"\n"
"       -L, --location\n"
, stdout);
 fputs(
"              (HTTP/HTTPS) If the server reports that the requested  page  has\n"
"              moved to a different location (indicated with a Location: header\n"
"              and a 3XX response code), this option will make  curl  redo  the\n"
"              request on the new place. If used together with -i, --include or\n"
"              -I, --head, headers from all requested pages will be shown. When\n"
"              authentication  is  used, curl only sends its credentials to the\n"
, stdout);
 fputs(
"              initial host. If a redirect takes curl to a different  host,  it\n"
"              won't  be  able to intercept the user+password. See also --loca-\n"
"              tion-trusted on how to change this. You can limit the amount  of\n"
"              redirects to follow by using the --max-redirs option.\n"
"\n"
"              When  curl follows a redirect and the request is not a plain GET\n"
"              (for example POST or PUT), it will do the following request with\n"
, stdout);
 fputs(
"              a GET if the HTTP response was 301, 302, or 303. If the response\n"
"              code was any other 3xx code, curl  will  re-send  the  following\n"
"              request using the same unmodified method.\n"
"\n"
"       --libcurl <file>\n"
"              Append  this  option  to any ordinary curl command line, and you\n"
"              will get a libcurl-using C source code written to the file  that\n"
"              does the equivalent of what your command-line operation does!\n"
"\n"
, stdout);
 fputs(
"              If  this  option is used several times, the last given file name\n"
"              will be used. (Added in 7.16.1)\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want  curl  to  use.  This\n"
"              feature is useful if you have a limited pipe and you'd like your\n"
"              transfer not to use your entire bandwidth.\n"
"\n"
"              The given speed is measured in bytes/second, unless a suffix  is\n"
, stdout);
 fputs(
"              appended.   Appending  'k' or 'K' will count the number as kilo-\n"
"              bytes, 'm' or M' makes it megabytes, while 'g' or 'G'  makes  it\n"
"              gigabytes. Examples: 200K, 3m and 1G.\n"
"\n"
"              The  given  rate  is the average speed counted during the entire\n"
"              transfer. It means that curl might use higher transfer speeds in\n"
"              short bursts, but over time it uses no more than the given rate.\n"
, stdout);
 fputs(
"              If  you  also use the -Y, --speed-limit option, that option will\n"
"              take precedence and might cripple the rate-limiting slightly, to\n"
"              help keeping the speed-limit logic working.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --local-port <num>[-num]\n"
"              Set a preferred number or range of local port numbers to use for\n"
"              the connection(s).  Note that  port  numbers  by  nature  are  a\n"
, stdout);
 fputs(
"              scarce resource that will be busy at times so setting this range\n"
"              to something too narrow might cause unnecessary connection setup\n"
"              failures. (Added in 7.15.2)\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS)  Like  -L,  --location,  but will allow sending the\n"
"              name + password to all hosts that the site may redirect to. This\n"
"              may or may not introduce a security breach if the site redirects\n"
, stdout);
 fputs(
"              you to a site to which  you'll  send  your  authentication  info\n"
"              (which is plaintext in the case of HTTP Basic authentication).\n"
"\n"
"       -m, --max-time <seconds>\n"
"              Maximum  time  in  seconds that you allow the whole operation to\n"
"              take.  This is useful for preventing your batch jobs from  hang-\n"
"              ing  for  hours  due  to slow networks or links going down.  See\n"
"              also the --connect-timeout option.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --mail-auth <address>\n"
"              (SMTP) Specify a single address. This will be  used  to  specify\n"
"              the  authentication  address  (identity)  of a submitted message\n"
"              that is being relayed to another server.\n"
"\n"
"              (Added in 7.25.0)\n"
"\n"
"       --mail-from <address>\n"
"              (SMTP) Specify a single address that the given mail  should  get\n"
"              sent from.\n"
"\n"
, stdout);
 fputs(
"              (Added in 7.20.0)\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify  the  maximum  size (in bytes) of a file to download. If\n"
"              the file requested is larger than this value, the transfer  will\n"
"              not start and curl will return with exit code 63.\n"
"\n"
"              NOTE:  The  file size is not always known prior to download, and\n"
"              for such files this option has no effect even if the file trans-\n"
, stdout);
 fputs(
"              fer  ends  up  being larger than this given limit. This concerns\n"
"              both FTP and HTTP transfers.\n"
"\n"
"       --mail-rcpt <address>\n"
"              (SMTP) Specify a single address that the given mail  should  get\n"
"              sent  to. This option can be used multiple times to specify many\n"
"              recipients.\n"
"\n"
"              (Added in 7.20.0)\n"
"\n"
"       --max-redirs <num>\n"
"              Set maximum number of  redirection-followings  allowed.  If  -L,\n"
, stdout);
 fputs(
"              --location is used, this option can be used to prevent curl from\n"
"              following redirections \"in absurdum\". By default, the  limit  is\n"
"              set  to 50 redirections. Set this option to -1 to make it limit-\n"
"              less.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --metalink\n"
"              This option can tell curl to parse and process a  given  URI  as\n"
, stdout);
 fputs(
"              Metalink  file  (both  version 3 and 4 (RFC 5854) are supported)\n"
"              and make use of the mirrors listed within for failover if  there\n"
"              are  errors (such as the file or server not being available). It\n"
"              will also verify the hash of the file after  the  download  com-\n"
"              pletes.  The Metalink file itself is downloaded and processed in\n"
"              memory and not stored in the local file system.\n"
"\n"
, stdout);
 fputs(
"              Example to use a remote Metalink file:\n"
"\n"
"              curl --metalink http://www.example.com/example.metalink\n"
"\n"
"              To use a Metalink file in the local file system, use FILE proto-\n"
"              col (file://):\n"
"\n"
"              curl --metalink file://example.metalink\n"
"\n"
"              Please  note  that if FILE protocol is disabled, there is no way\n"
"              to use a local Metalink file at the time of this  writing.  Also\n"
, stdout);
 fputs(
"              note  that  if  --metalink  and  --include  are  used  together,\n"
"              --include will be ignored. This is because including headers  in\n"
"              the  response  will break Metalink parser and if the headers are\n"
"              included in the file described in Metalink file, hash check will\n"
"              fail.\n"
"\n"
"              (Added in 7.27.0, if built against the libmetalink library.)\n"
"\n"
"       -n, --netrc\n"
, stdout);
 fputs(
"              Makes  curl  scan  the  .netrc  (_netrc  on Windows) file in the\n"
"              user's home directory for login name and password. This is typi-\n"
"              cally  used for FTP on UNIX. If used with HTTP, curl will enable\n"
"              user authentication. See netrc(4) or ftp(1) for details  on  the\n"
"              file  format.  Curl  will not complain if that file doesn't have\n"
"              the right permissions (it should not be either world- or  group-\n"
, stdout);
 fputs(
"              readable).  The  environment variable \"HOME\" is used to find the\n"
"              home directory.\n"
"\n"
"              A quick and very simple example of how  to  setup  a  .netrc  to\n"
"              allow  curl to FTP to the machine host.domain.com with user name\n"
"              'myself' and password 'secret' should look similar to:\n"
"\n"
"              machine host.domain.com login myself password secret\n"
"\n"
"       -N, --no-buffer\n"
, stdout);
 fputs(
"              Disables the buffering of the output stream. In normal work sit-\n"
"              uations,  curl  will  use a standard buffered output stream that\n"
"              will have the effect that it will output the data in chunks, not\n"
"              necessarily  exactly  when  the data arrives.  Using this option\n"
"              will disable that buffering.\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --buffer to enforce the buffering.\n"
"\n"
, stdout);
 fputs(
"       --netrc-file\n"
"              This  option  is similar to --netrc, except that you provide the\n"
"              path (absolute or relative) to the netrc file that  Curl  should\n"
"              use.   You  can  only  specify one netrc file per invocation. If\n"
"              several --netrc-file options are provided,  only  the  last  one\n"
"              will be used.  (Added in 7.21.5)\n"
"\n"
"              This  option  overrides  any use of --netrc as they are mutually\n"
, stdout);
 fputs(
"              exclusive.  It will also abide by --netrc-optional if specified.\n"
"\n"
"       --netrc-optional\n"
"              Very similar to --netrc, but this option makes the .netrc  usage\n"
"              optional and not mandatory as the --netrc option does.\n"
"\n"
"       --negotiate\n"
"              (HTTP)  Enables  GSS-Negotiate authentication. The GSS-Negotiate\n"
"              method was designed by Microsoft and is used in their web appli-\n"
, stdout);
 fputs(
"              cations.  It  is  primarily  meant  as  a  support for Kerberos5\n"
"              authentication but may be also used along with another authenti-\n"
"              cation method. For more information see IETF draft draft-brezak-\n"
"              spnego-http-04.txt.\n"
"\n"
"              If you want to enable Negotiate for your  proxy  authentication,\n"
"              then use --proxy-negotiate.\n"
"\n"
"              This  option  requires a library built with GSSAPI support. This\n"
, stdout);
 fputs(
"              is not very common. Use -V, --version to  see  if  your  version\n"
"              supports GSS-Negotiate.\n"
"\n"
"              When  using this option, you must also provide a fake -u, --user\n"
"              option to activate the authentication code properly.  Sending  a\n"
"              '-u  :'  is  enough  as  the  user name and password from the -u\n"
"              option aren't actually used.\n"
"\n"
"              If this option is used several times,  only  the  first  one  is\n"
"              used.\n"
"\n"
, stdout);
 fputs(
"       --no-keepalive\n"
"              Disables the use of keepalive messages on the TCP connection, as\n"
"              by default curl enables them.\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --keepalive to enforce keepalive.\n"
"\n"
"       --no-sessionid\n"
"              (SSL)  Disable curl's use of SSL session-ID caching.  By default\n"
"              all transfers are done using the cache. Note that while  nothing\n"
, stdout);
 fputs(
"              should  ever  get  hurt  by attempting to reuse SSL session-IDs,\n"
"              there seem to be broken SSL implementations in the wild that may\n"
"              require  you to disable this in order for you to succeed. (Added\n"
"              in 7.16.0)\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --sessionid to enforce session-ID caching.\n"
"\n"
"       --noproxy <no-proxy-list>\n"
, stdout);
 fputs(
"              Comma-separated  list  of hosts which do not use a proxy, if one\n"
"              is specified.  The only wildcard is a single * character,  which\n"
"              matches all hosts, and effectively disables the proxy. Each name\n"
"              in this list is matched as either a domain  which  contains  the\n"
"              hostname,  or  the hostname itself. For example, local.com would\n"
"              match  local.com,  local.com:80,  and  www.local.com,  but   not\n"
, stdout);
 fputs(
"              www.notlocal.com.  (Added in 7.19.4).\n"
"\n"
"       --ntlm (HTTP)  Enables  NTLM  authentication.  The  NTLM authentication\n"
"              method was designed by Microsoft and is used by IIS web servers.\n"
"              It  is a proprietary protocol, reverse-engineered by clever peo-\n"
"              ple and implemented in curl based on their efforts. This kind of\n"
"              behavior  should  not be endorsed, you should encourage everyone\n"
, stdout);
 fputs(
"              who uses NTLM to switch to a public and  documented  authentica-\n"
"              tion method instead, such as Digest.\n"
"\n"
"              If  you  want to enable NTLM for your proxy authentication, then\n"
"              use --proxy-ntlm.\n"
"\n"
"              This option requires a library built with SSL support.  Use  -V,\n"
"              --version to see if your curl supports NTLM.\n"
"\n"
"              If  this  option  is  used  several times, only the first one is\n"
"              used.\n"
"\n"
, stdout);
 fputs(
"       -o, --output <file>\n"
"              Write output to <file> instead of stdout. If you are using {} or\n"
"              []  to  fetch  multiple documents, you can use '#' followed by a\n"
"              number in the <file> specifier. That variable will  be  replaced\n"
"              with the current string for the URL being fetched. Like in:\n"
"\n"
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
, stdout);
 fputs(
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may use this option as many times as the number of URLs you\n"
"              have.\n"
"\n"
"              See also the --create-dirs option to create the  local  directo-\n"
"              ries  dynamically.  Specifying the output as '-' (a single dash)\n"
"              will force the output to be done to stdout.\n"
"\n"
"       -O, --remote-name\n"
"              Write output to a local file named like the remote file we  get.\n"
, stdout);
 fputs(
"              (Only  the file part of the remote file is used, the path is cut\n"
"              off.)\n"
"\n"
"              The remote file name to use for saving  is  extracted  from  the\n"
"              given URL, nothing else.\n"
"\n"
"              Consequentially,  the  file will be saved in the current working\n"
"              directory. If you want the file saved in a different  directory,\n"
"              make sure you change current working directory before you invoke\n"
, stdout);
 fputs(
"              curl with the -O, --remote-name flag!\n"
"\n"
"              You may use this option as many times as the number of URLs  you\n"
"              have.\n"
"\n"
"       -p, --proxytunnel\n"
"              When an HTTP proxy is used (-x, --proxy), this option will cause\n"
"              non-HTTP protocols  to  attempt  to  tunnel  through  the  proxy\n"
"              instead  of merely using it to do HTTP-like operations. The tun-\n"
"              nel approach is made with the HTTP  proxy  CONNECT  request  and\n"
, stdout);
 fputs(
"              requires that the proxy allows direct connect to the remote port\n"
"              number curl wants to tunnel through to.\n"
"\n"
"       -P, --ftp-port <address>\n"
"              (FTP) Reverses the default initiator/listener  roles  when  con-\n"
"              necting  with  FTP.  This  switch makes curl use active mode. In\n"
"              practice, curl then tells the server  to  connect  back  to  the\n"
"              client's specified address and port, while passive mode asks the\n"
, stdout);
 fputs(
"              server to setup an IP address and port for  it  to  connect  to.\n"
"              <address> should be one of:\n"
"\n"
"              interface\n"
"                     i.e  \"eth0\"  to  specify which interface's IP address you\n"
"                     want to use (Unix only)\n"
"\n"
"              IP address\n"
"                     i.e \"192.168.10.1\" to specify the exact IP address\n"
"\n"
"              host name\n"
"                     i.e \"my.host.domain\" to specify the machine\n"
"\n"
, stdout);
 fputs(
"              -      make curl pick the same IP address that is  already  used\n"
"                     for the control connection\n"
"\n"
"       If  this  option is used several times, the last one will be used. Dis-\n"
"       able the use of PORT with --ftp-pasv. Disable the attempt  to  use  the\n"
"       EPRT  command  instead  of PORT by using --disable-eprt. EPRT is really\n"
"       PORT++.\n"
"\n"
"       Starting in 7.19.5, you can append \":[start]-[end]\" to the right of the\n"
, stdout);
 fputs(
"       address,  to tell curl what TCP port range to use. That means you spec-\n"
"       ify a port range, from a lower to a  higher  number.  A  single  number\n"
"       works  as well, but do note that it increases the risk of failure since\n"
"       the port may not be available.\n"
"\n"
"       --pass <phrase>\n"
"              (SSL/SSH) Passphrase for the private key\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --post301\n"
, stdout);
 fputs(
"              (HTTP) Tells curl to respect RFC  2616/10.3.2  and  not  convert\n"
"              POST  requests  into GET requests when following a 301 redirect-\n"
"              ion. The non-RFC behaviour is ubiquitous  in  web  browsers,  so\n"
"              curl  does  the  conversion  by default to maintain consistency.\n"
"              However, a server may require a POST to remain a POST after such\n"
"              a  redirection.  This  option  is meaningful only when using -L,\n"
, stdout);
 fputs(
"              --location (Added in 7.17.1)\n"
"\n"
"       --post302\n"
"              (HTTP) Tells curl to respect RFC  2616/10.3.2  and  not  convert\n"
"              POST  requests  into GET requests when following a 302 redirect-\n"
"              ion. The non-RFC behaviour is ubiquitous  in  web  browsers,  so\n"
"              curl  does  the  conversion  by default to maintain consistency.\n"
"              However, a server may require a POST to remain a POST after such\n"
, stdout);
 fputs(
"              a  redirection.  This  option  is meaningful only when using -L,\n"
"              --location (Added in 7.19.1)\n"
"\n"
"       --proto <protocols>\n"
"              Tells  curl  to  use  the  listed  protocols  for  its   initial\n"
"              retrieval. Protocols are evaluated left to right, are comma sep-\n"
"              arated, and are each a protocol name or 'all',  optionally  pre-\n"
"              fixed by zero or more modifiers. Available modifiers are:\n"
"\n"
, stdout);
 fputs(
"              +  Permit this protocol in addition to protocols already permit-\n"
"                 ted (this is the default if no modifier is used).\n"
"\n"
"              -  Deny this protocol, removing it from the  list  of  protocols\n"
"                 already permitted.\n"
"\n"
"              =  Permit  only this protocol (ignoring the list already permit-\n"
"                 ted), though subject  to  later  modification  by  subsequent\n"
"                 entries in the comma separated list.\n"
"\n"
, stdout);
 fputs(
"              For example:\n"
"\n"
"              --proto -ftps  uses the default protocols, but disables ftps\n"
"\n"
"              --proto -all,https,+http\n"
"                             only enables http and https\n"
"\n"
"              --proto =http,https\n"
"                             also only enables http and https\n"
"\n"
"              Unknown  protocols  produce  a  warning.  This allows scripts to\n"
"              safely rely on being able to disable potentially dangerous  pro-\n"
, stdout);
 fputs(
"              tocols,  without  relying  upon  support for that protocol being\n"
"              built into curl to avoid an error.\n"
"\n"
"              This option can be used multiple times, in which case the effect\n"
"              is  the same as concatenating the protocols into one instance of\n"
"              the option.\n"
"\n"
"              (Added in 7.20.2)\n"
"\n"
"       --proto-redir <protocols>\n"
"              Tells curl to use the listed protocols  after  a  redirect.  See\n"
, stdout);
 fputs(
"              --proto for how protocols are represented.\n"
"\n"
"              (Added in 7.20.2)\n"
"\n"
"       --proxy-anyauth\n"
"              Tells  curl to pick a suitable authentication method when commu-\n"
"              nicating with  the  given  proxy.  This  might  cause  an  extra\n"
"              request/response round-trip. (Added in 7.13.2)\n"
"\n"
"       --proxy-basic\n"
"              Tells  curl  to use HTTP Basic authentication when communicating\n"
, stdout);
 fputs(
"              with the given proxy. Use --basic for enabling HTTP Basic with a\n"
"              remote  host.  Basic  is  the default authentication method curl\n"
"              uses with proxies.\n"
"\n"
"       --proxy-digest\n"
"              Tells curl to use HTTP Digest authentication when  communicating\n"
"              with the given proxy. Use --digest for enabling HTTP Digest with\n"
"              a remote host.\n"
"\n"
"       --proxy-negotiate\n"
, stdout);
 fputs(
"              Tells curl to use HTTP Negotiate authentication when communicat-\n"
"              ing  with  the  given  proxy.  Use --negotiate for enabling HTTP\n"
"              Negotiate with a remote host. (Added in 7.17.1)\n"
"\n"
"       --proxy-ntlm\n"
"              Tells curl to use HTTP NTLM  authentication  when  communicating\n"
"              with the given proxy. Use --ntlm for enabling NTLM with a remote\n"
"              host.\n"
"\n"
"       --proxy1.0 <proxyhost[:port]>\n"
, stdout);
 fputs(
"              Use the specified HTTP 1.0 proxy. If  the  port  number  is  not\n"
"              specified, it is assumed at port 1080.\n"
"\n"
"              The  only difference between this and the HTTP proxy option (-x,\n"
"              --proxy), is that attempts to use CONNECT through the proxy will\n"
"              specify an HTTP 1.0 protocol instead of the default HTTP 1.1.\n"
"\n"
"       --pubkey <key>\n"
"              (SSH)  Public  key  file name. Allows you to provide your public\n"
, stdout);
 fputs(
"              key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -q     If used as the first parameter on the command line,  the  curlrc\n"
"              config  file will not be read and used. See the -K, --config for\n"
"              details on the default config file search path.\n"
"\n"
"       -Q, --quote <command>\n"
"              (FTP/SFTP) Send an arbitrary command to the remote FTP  or  SFTP\n"
, stdout);
 fputs(
"              server.  Quote commands are sent BEFORE the transfer takes place\n"
"              (just after the initial PWD command in an FTP  transfer,  to  be\n"
"              exact). To make commands take place after a successful transfer,\n"
"              prefix them with a dash '-'.  To make  commands  be  sent  after\n"
"              curl has changed the working directory, just before the transfer\n"
"              command(s), prefix the command with a '+'  (this  is  only  sup-\n"
, stdout);
 fputs(
"              ported  for FTP). You may specify any number of commands. If the\n"
"              server returns failure for one of the commands, the entire oper-\n"
"              ation  will  be aborted. You must send syntactically correct FTP\n"
"              commands as RFC 959 defines to FTP servers, or one of  the  com-\n"
"              mands  listed  below  to  SFTP servers.  This option can be used\n"
"              multiple times. When speaking to an FTP server, prefix the  com-\n"
, stdout);
 fputs(
"              mand with an asterisk (*) to make curl continue even if the com-\n"
"              mand fails as by default curl will stop at first failure.\n"
"\n"
"              SFTP is a binary protocol. Unlike for FTP, curl interprets  SFTP\n"
"              quote  commands  itself before sending them to the server.  File\n"
"              names may be quoted shell-style to embed spaces or special char-\n"
"              acters.   Following is the list of all supported SFTP quote com-\n"
"              mands:\n"
"\n"
, stdout);
 fputs(
"              chgrp group file\n"
"                     The chgrp command sets the group ID of the file named  by\n"
"                     the  file  operand to the group ID specified by the group\n"
"                     operand. The group operand is a decimal integer group ID.\n"
"\n"
"              chmod mode file\n"
"                     The chmod command modifies the  file  mode  bits  of  the\n"
"                     specified file. The mode operand is an octal integer mode\n"
"                     number.\n"
"\n"
, stdout);
 fputs(
"              chown user file\n"
"                     The chown command sets the owner of the file named by the\n"
"                     file  operand  to the user ID specified by the user oper-\n"
"                     and. The user operand is a decimal integer user ID.\n"
"\n"
"              ln source_file target_file\n"
"                     The ln and symlink commands create a symbolic link at the\n"
"                     target_file  location  pointing  to the source_file loca-\n"
"                     tion.\n"
"\n"
, stdout);
 fputs(
"              mkdir directory_name\n"
"                     The mkdir command creates  the  directory  named  by  the\n"
"                     directory_name operand.\n"
"\n"
"              pwd    The pwd command returns the absolute pathname of the cur-\n"
"                     rent working directory.\n"
"\n"
"              rename source target\n"
"                     The rename command renames the file or directory named by\n"
"                     the  source  operand to the destination path named by the\n"
, stdout);
 fputs(
"                     target operand.\n"
"\n"
"              rm file\n"
"                     The rm command removes the file specified by the file op-\n"
"                     erand.\n"
"\n"
"              rmdir directory\n"
"                     The  rmdir  command removes the directory entry specified\n"
"                     by the directory operand, provided it is empty.\n"
"\n"
"              symlink source_file target_file\n"
"                     See ln.\n"
"\n"
"       -r, --range <range>\n"
, stdout);
 fputs(
"              (HTTP/FTP/SFTP/FILE) Retrieve a byte range (i.e a partial  docu-\n"
"              ment)  from  a  HTTP/1.1,  FTP  or  SFTP server or a local FILE.\n"
"              Ranges can be specified in a number of ways.\n"
"\n"
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500-     specifies the bytes from offset 9500 and forward\n"
"\n"
, stdout);
 fputs(
"              0-0,-1    specifies the first and last byte only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
"                        specifies two separate 100-byte ranges(*)(H)\n"
"\n"
"       (*) = NOTE that this will cause the server to reply  with  a  multipart\n"
"       response!\n"
"\n"
"       Only  digit characters (0-9) are valid in the 'start' and 'stop' fields\n"
, stdout);
 fputs(
"       of the 'start-stop' range syntax. If a non-digit character is given  in\n"
"       the  range, the server's response will be unspecified, depending on the\n"
"       server's configuration.\n"
"\n"
"       You should also be aware that many HTTP/1.1 servers do  not  have  this\n"
"       feature  enabled,  so  that  when  you  attempt  to get a range, you'll\n"
"       instead get the whole document.\n"
"\n"
"       FTP and SFTP range downloads only support the simple 'start-stop'  syn-\n"
, stdout);
 fputs(
"       tax  (optionally  with  one of the numbers omitted). FTP use depends on\n"
"       the extended FTP command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
"       -R, --remote-time\n"
"              When used, this will make curl attempt to figure out  the  time-\n"
"              stamp  of  the  remote  file,  and if that is available make the\n"
"              local file get that same timestamp.\n"
"\n"
"       --random-file <file>\n"
, stdout);
 fputs(
"              (SSL) Specify the path name to file containing what will be con-\n"
"              sidered  as  random  data.  The  data is used to seed the random\n"
"              engine for SSL connections.  See also the --egd-file option.\n"
"\n"
"       --raw  (HTTP) When used, it disables all internal HTTP decoding of con-\n"
"              tent  or  transfer  encodings  and  instead makes them passed on\n"
"              unaltered, raw. (Added in 7.16.2)\n"
"\n"
"       --remote-name-all\n"
, stdout);
 fputs(
"              This option changes the default action for all given URLs to  be\n"
"              dealt with as if -O, --remote-name were used for each one. So if\n"
"              you want to disable that for a specific URL after --remote-name-\n"
"              all  has  been  used,  you  must use \"-o -\" or --no-remote-name.\n"
"              (Added in 7.19.0)\n"
"\n"
"       --resolve <host:port:address>\n"
"              Provide a custom address for a  specific  host  and  port  pair.\n"
, stdout);
 fputs(
"              Using  this,  you  can make the curl requests(s) use a specified\n"
"              address and prevent the otherwise normally resolved  address  to\n"
"              be  used.  Consider it a sort of /etc/hosts alternative provided\n"
"              on the command line. The port number should be the  number  used\n"
"              for  the  specific  protocol the host will be used for. It means\n"
"              you need several entries if you want to provide address for  the\n"
, stdout);
 fputs(
"              same host but different ports.\n"
"\n"
"              This  option  can  be  used many times to add many host names to\n"
"              resolve.\n"
"\n"
"              (Added in 7.21.3)\n"
"\n"
"       --retry <num>\n"
"              If a transient error is returned when curl tries  to  perform  a\n"
"              transfer,  it  will retry this number of times before giving up.\n"
"              Setting the number to 0 makes curl do no retries (which  is  the\n"
, stdout);
 fputs(
"              default).  Transient  error  means either: a timeout, an FTP 4xx\n"
"              response code or an HTTP 5xx response code.\n"
"\n"
"              When curl is about to retry a transfer, it will first  wait  one\n"
"              second  and  then for all forthcoming retries it will double the\n"
"              waiting time until it reaches 10 minutes which then will be  the\n"
"              delay  between  the rest of the retries.  By using --retry-delay\n"
, stdout);
 fputs(
"              you  disable  this  exponential  backoff  algorithm.  See   also\n"
"              --retry-max-time  to  limit  the total time allowed for retries.\n"
"              (Added in 7.12.3)\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --retry-delay <seconds>\n"
"              Make curl sleep this amount of time before  each  retry  when  a\n"
"              transfer  has  failed  with  a  transient  error (it changes the\n"
, stdout);
 fputs(
"              default backoff time algorithm between retries). This option  is\n"
"              only  interesting if --retry is also used. Setting this delay to\n"
"              zero will make curl use the default  backoff  time.   (Added  in\n"
"              7.12.3)\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --retry-max-time <seconds>\n"
"              The  retry  timer  is  reset  before the first transfer attempt.\n"
, stdout);
 fputs(
"              Retries will be done as usual (see --retry) as long as the timer\n"
"              hasn't reached this given limit. Notice that if the timer hasn't\n"
"              reached the limit, the request will be made and  while  perform-\n"
"              ing,  it may take longer than this given time period. To limit a\n"
"              single request's maximum time, use  -m,  --max-time.   Set  this\n"
"              option to zero to not timeout retries. (Added in 7.12.3)\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -s, --silent\n"
"              Silent  or  quiet  mode. Don't show progress meter or error mes-\n"
"              sages.  Makes Curl mute.\n"
"\n"
"       -S, --show-error\n"
"              When used with -s it makes curl show  an  error  message  if  it\n"
"              fails.\n"
"\n"
"       --ssl  (FTP,  POP3,  IMAP, SMTP) Try to use SSL/TLS for the connection.\n"
, stdout);
 fputs(
"              Reverts to a non-secure connection if the server doesn't support\n"
"              SSL/TLS.   See also --ftp-ssl-control and --ssl-reqd for differ-\n"
"              ent levels of encryption required. (Added in 7.20.0)\n"
"\n"
"              This option was formerly known as --ftp-ssl (Added  in  7.11.0).\n"
"              That  option  name  can  still  be used but will be removed in a\n"
"              future version.\n"
"\n"
"       --ssl-reqd\n"
, stdout);
 fputs(
"              (FTP, POP3, IMAP, SMTP)  Require  SSL/TLS  for  the  connection.\n"
"              Terminates the connection if the server doesn't support SSL/TLS.\n"
"              (Added in 7.20.0)\n"
"\n"
"              This option was  formerly  known  as  --ftp-ssl-reqd  (added  in\n"
"              7.15.5).  That option name can still be used but will be removed\n"
"              in a future version.\n"
"\n"
"       --ssl-allow-beast\n"
"              (SSL) This option tells curl to not work around a security  flaw\n"
, stdout);
 fputs(
"              in the SSL3 and TLS1.0 protocols known as BEAST.  If this option\n"
"              isn't used, the SSL layer may use work-arounds  known  to  cause\n"
"              interoperability  problems  with some older SSL implementations.\n"
"              WARNING: this option loosens the SSL security, and by using this\n"
"              flag you ask for exactly that.  (Added in 7.25.0)\n"
"\n"
"       --socks4 <host[:port]>\n"
"              Use the specified SOCKS4 proxy. If the port number is not speci-\n"
, stdout);
 fputs(
"              fied, it is assumed at port 1080. (Added in 7.15.2)\n"
"\n"
"              This option overrides any previous use of -x, --proxy,  as  they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks4 proxy with -x, --proxy using a socks4:// protocol prefix.\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --socks4a <host[:port]>\n"
, stdout);
 fputs(
"              Use the specified SOCKS4a proxy. If the port number is not spec-\n"
"              ified, it is assumed at port 1080. (Added in 7.18.0)\n"
"\n"
"              This  option  overrides any previous use of -x, --proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks4a  proxy with -x, --proxy using a socks4a:// protocol pre-\n"
"              fix.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --socks5-hostname <host[:port]>\n"
"              Use the specified SOCKS5 proxy (and let the  proxy  resolve  the\n"
"              host  name).  If the port number is not specified, it is assumed\n"
"              at port 1080. (Added in 7.18.0)\n"
"\n"
"              This option overrides any previous use of -x, --proxy,  as  they\n"
"              are mutually exclusive.\n"
"\n"
, stdout);
 fputs(
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks5 hostname proxy with -x, --proxy using a socks5h:// proto-\n"
"              col prefix.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              (This option was  previously  wrongly  documented  and  used  as\n"
"              --socks without the number appended.)\n"
"\n"
"       --socks5 <host[:port]>\n"
, stdout);
 fputs(
"              Use  the  specified  SOCKS5  proxy  -  but resolve the host name\n"
"              locally. If the port number is not specified, it is  assumed  at\n"
"              port 1080.\n"
"\n"
"              This  option  overrides any previous use of -x, --proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks5 proxy with -x, --proxy using a socks5:// protocol prefix.\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"              (This option was  previously  wrongly  documented  and  used  as\n"
"              --socks without the number appended.)\n"
"\n"
"              This  option (as well as --socks4) does not work with IPV6, FTPS\n"
"              or LDAP.\n"
"\n"
"       --socks5-gssapi-service <servicename>\n"
"              The default service name for a socks server is rcmd/server-fqdn.\n"
"              This option allows you to change it.\n"
"\n"
, stdout);
 fputs(
"              Examples:   --socks5  proxy-name  --socks5-gssapi-service  sockd\n"
"              would use sockd/proxy-name --socks5 proxy-name  --socks5-gssapi-\n"
"              service  sockd/real-name  would  use  sockd/real-name  for cases\n"
"              where the proxy-name does not match the principal name.   (Added\n"
"              in 7.19.4).\n"
"\n"
"       --socks5-gssapi-nec\n"
"              As  part  of the gssapi negotiation a protection mode is negoti-\n"
, stdout);
 fputs(
"              ated. RFC 1961 says in section 4.3/4.4 it should  be  protected,\n"
"              but  the  NEC  reference  implementation  does  not.  The option\n"
"              --socks5-gssapi-nec allows the unprotected exchange of the  pro-\n"
"              tection mode negotiation. (Added in 7.19.4).\n"
"\n"
"       --stderr <file>\n"
"              Redirect  all writes to stderr to the specified file instead. If\n"
"              the file name is a plain '-', it is instead written to stdout.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -t, --telnet-option <OPT=val>\n"
"              Pass options to the telnet protocol. Supported options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T, --upload-file <file>\n"
"              This transfers the specified local file to the  remote  URL.  If\n"
, stdout);
 fputs(
"              there is no file part in the specified URL, Curl will append the\n"
"              local file name. NOTE that you must use a trailing / on the last\n"
"              directory  to really prove to Curl that there is no file name or\n"
"              curl will think that your last directory name is the remote file\n"
"              name to use. That will most likely cause the upload operation to\n"
"              fail. If this is used on an HTTP(S) server, the PUT command will\n"
"              be used.\n"
"\n"
, stdout);
 fputs(
"              Use  the file name \"-\" (a single dash) to use stdin instead of a\n"
"              given file.  Alternately, the file name \".\"  (a  single  period)\n"
"              may  be  specified  instead  of \"-\" to use stdin in non-blocking\n"
"              mode to  allow  reading  server  output  while  stdin  is  being\n"
"              uploaded.\n"
"\n"
"              You can specify one -T for each URL on the command line. Each -T\n"
, stdout);
 fputs(
"              + URL pair specifies what to upload and to where. curl also sup-\n"
"              ports \"globbing\" of the -T argument, meaning that you can upload\n"
"              multiple files to a single URL by using the  same  URL  globbing\n"
"              style supported in the URL, like this:\n"
"\n"
"              curl -T \"{file1,file2}\" http://www.uploadtothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl -T \"img[1-1000].png\" ftp://ftp.picturemania.com/upload/\n"
"\n"
"       --tcp-nodelay\n"
, stdout);
 fputs(
"              Turn  on the TCP_NODELAY option. See the curl_easy_setopt(3) man\n"
"              page for details about this option. (Added in 7.11.2)\n"
"\n"
"       --tftp-blksize <value>\n"
"              (TFTP) Set TFTP BLKSIZE option (must be >512). This is the block\n"
"              size that curl will try to use when transferring data to or from\n"
"              a TFTP server. By default 512 bytes will be used.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"              (Added in 7.20.0)\n"
"\n"
"       --tlsauthtype <authtype>\n"
"              Set TLS  authentication  type.  Currently,  the  only  supported\n"
"              option  is  \"SRP\",  for  TLS-SRP  (RFC  5054).  If --tlsuser and\n"
"              --tlspassword are specified but --tlsauthtype is not, then  this\n"
"              option defaults to \"SRP\".  (Added in 7.21.4)\n"
"\n"
"       --tlsuser <user>\n"
"              Set  username  for use with the TLS authentication method speci-\n"
, stdout);
 fputs(
"              fied with --tlsauthtype. Requires  that  --tlspassword  also  be\n"
"              set.  (Added in 7.21.4)\n"
"\n"
"       --tlspassword <password>\n"
"              Set  password  for use with the TLS authentication method speci-\n"
"              fied with --tlsauthtype. Requires that --tlsuser  also  be  set.\n"
"              (Added in 7.21.4)\n"
"\n"
"       --tr-encoding\n"
"              (HTTP) Request a compressed Transfer-Encoding response using one\n"
, stdout);
 fputs(
"              of the algorithms curl supports, and uncompress the  data  while\n"
"              receiving it.\n"
"\n"
"              (Added in 7.21.6)\n"
"\n"
"       --trace <file>\n"
"              Enables  a  full  trace  dump of all incoming and outgoing data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This option overrides previous uses of -v, --verbose or --trace-\n"
"              ascii.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables a full trace dump of all  incoming  and  outgoing  data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the hex part and\n"
"              only  shows  the ASCII part of the dump. It makes smaller output\n"
, stdout);
 fputs(
"              that might be easier to read for untrained humans.\n"
"\n"
"              This option overrides previous uses of -v, --verbose or --trace.\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-time\n"
"              Prepends a time stamp to each trace or verbose  line  that  curl\n"
"              displays.  (Added in 7.14.0)\n"
"\n"
"       -u, --user <user:password>\n"
"              Specify the user name and password to use for server authentica-\n"
, stdout);
 fputs(
"              tion. Overrides -n, --netrc and --netrc-optional.\n"
"\n"
"              If you just give the user name (without entering a  colon)  curl\n"
"              will prompt for a password.\n"
"\n"
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-u :\".\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -U, --proxy-user <user:password>\n"
"              Specify the user name and password to use for proxy  authentica-\n"
"              tion.\n"
"\n"
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-U :\".\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify a URL to fetch. This option is  mostly  handy  when  you\n"
"              want to specify URL(s) in a config file.\n"
"\n"
"              This  option  may  be used any number of times. To control where\n"
"              this URL is written, use the -o, --output or the  -O,  --remote-\n"
"              name options.\n"
"       -v, --verbose\n"
, stdout);
 fputs(
"              Makes  the  fetching  more  verbose/talkative. Mostly useful for\n"
"              debugging. A line starting with '>' means \"header data\" sent  by\n"
"              curl, '<' means \"header data\" received by curl that is hidden in\n"
"              normal cases, and a line starting with '*' means additional info\n"
"              provided by curl.\n"
"\n"
"              Note  that  if  you  only  want  HTTP headers in the output, -i,\n"
"              --include might be the option you're looking for.\n"
"\n"
, stdout);
 fputs(
"              If you think this option still doesn't give you enough  details,\n"
"              consider using --trace or --trace-ascii instead.\n"
"\n"
"              This option overrides previous uses of --trace-ascii or --trace.\n"
"\n"
"              Use -s, --silent to make curl quiet.\n"
"\n"
"       -w, --write-out <format>\n"
"              Defines what to display on stdout after a completed and success-\n"
"              ful operation. The format is a string  that  may  contain  plain\n"
, stdout);
 fputs(
"              text mixed with any number of variables. The string can be spec-\n"
"              ified as \"string\", to get read from a particular file you  spec-\n"
"              ify  it  \"@filename\"  and  to  tell curl to read the format from\n"
"              stdin you write \"@-\".\n"
"\n"
"              The variables present in the output format will  be  substituted\n"
"              by  the  value or text that curl thinks fit, as described below.\n"
, stdout);
 fputs(
"              All variables are specified as %{variable_name} and to output  a\n"
"              normal  % you just write them as %%. You can output a newline by\n"
"              using \\n, a carriage return with \\r and a tab space with \\t.\n"
"\n"
"              NOTE: The %-symbol is a special symbol in the win32-environment,\n"
"              where  all  occurrences  of  %  must  be doubled when using this\n"
"              option.\n"
"\n"
"              The variables available are:\n"
"\n"
, stdout);
 fputs(
"              content_type   The Content-Type of the  requested  document,  if\n"
"                             there was any.\n"
"\n"
"              filename_effective\n"
"                             The  ultimate  filename  that curl writes out to.\n"
"                             This is only meaningful if curl is told to  write\n"
"                             to  a  file  with  the  --remote-name or --output\n"
"                             option. It's most useful in combination with  the\n"
, stdout);
 fputs(
"                             --remote-header-name option. (Added in 7.25.1)\n"
"\n"
"              ftp_entry_path The initial path curl ended up in when logging on\n"
"                             to the remote FTP server. (Added in 7.15.4)\n"
"\n"
"              http_code      The numerical response code that was found in the\n"
"                             last  retrieved  HTTP(S)  or  FTP(s) transfer. In\n"
"                             7.18.2 the alias response_code was added to  show\n"
, stdout);
 fputs(
"                             the same info.\n"
"\n"
"              http_connect   The  numerical  code  that  was found in the last\n"
"                             response  (from  a  proxy)  to  a  curl   CONNECT\n"
"                             request. (Added in 7.12.4)\n"
"\n"
"              local_ip       The  IP  address  of  the  local  end of the most\n"
"                             recently done connection - can be either IPv4  or\n"
"                             IPv6 (Added in 7.29.0)\n"
"\n"
, stdout);
 fputs(
"              local_port     The  local  port number of the most recently done\n"
"                             connection (Added in 7.29.0)\n"
"\n"
"              num_connects   Number of new connects made in the recent  trans-\n"
"                             fer. (Added in 7.12.3)\n"
"\n"
"              num_redirects  Number  of  redirects  that  were followed in the\n"
"                             request. (Added in 7.12.3)\n"
"\n"
"              redirect_url   When an HTTP request was made without -L to  fol-\n"
, stdout);
 fputs(
"                             low redirects, this variable will show the actual\n"
"                             URL a redirect  would  take  you  to.  (Added  in\n"
"                             7.18.2)\n"
"\n"
"              remote_ip      The  remote  IP address of the most recently done\n"
"                             connection - can be either IPv4 or IPv6 (Added in\n"
"                             7.29.0)\n"
"\n"
"              remote_port    The  remote port number of the most recently done\n"
, stdout);
 fputs(
"                             connection (Added in 7.29.0)\n"
"\n"
"              size_download  The total amount of bytes that were downloaded.\n"
"\n"
"              size_header    The total amount of bytes of the downloaded head-\n"
"                             ers.\n"
"\n"
"              size_request   The  total  amount of bytes that were sent in the\n"
"                             HTTP request.\n"
"\n"
"              size_upload    The total amount of bytes that were uploaded.\n"
"\n"
, stdout);
 fputs(
"              speed_download The average download speed that curl measured for\n"
"                             the complete download. Bytes per second.\n"
"\n"
"              speed_upload   The  average  upload speed that curl measured for\n"
"                             the complete upload. Bytes per second.\n"
"\n"
"              ssl_verify_result\n"
"                             The result of the SSL peer certificate  verifica-\n"
"                             tion that was requested. 0 means the verification\n"
, stdout);
 fputs(
"                             was successful. (Added in 7.19.0)\n"
"\n"
"              time_appconnect\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until  the  SSL/SSH/etc  connect/handshake to the\n"
"                             remote host was completed. (Added in 7.19.0)\n"
"\n"
"              time_connect   The time, in seconds,  it  took  from  the  start\n"
"                             until  the  TCP  connect  to  the remote host (or\n"
, stdout);
 fputs(
"                             proxy) was completed.\n"
"\n"
"              time_namelookup\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until the name resolving was completed.\n"
"\n"
"              time_pretransfer\n"
"                             The  time,  in  seconds,  it  took from the start\n"
"                             until the file transfer was just about to  begin.\n"
"                             This includes all pre-transfer commands and nego-\n"
, stdout);
 fputs(
"                             tiations that are specific to the particular pro-\n"
"                             tocol(s) involved.\n"
"\n"
"              time_redirect  The time, in seconds, it took for all redirection\n"
"                             steps include name lookup,  connect,  pretransfer\n"
"                             and  transfer  before  the  final transaction was\n"
"                             started. time_redirect shows the complete  execu-\n"
, stdout);
 fputs(
"                             tion  time  for  multiple redirections. (Added in\n"
"                             7.12.3)\n"
"\n"
"              time_starttransfer\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until  the first byte was just about to be trans-\n"
"                             ferred. This includes time_pretransfer  and  also\n"
"                             the  time  the  server  needed  to  calculate the\n"
, stdout);
 fputs(
"                             result.\n"
"\n"
"              time_total     The total time, in seconds, that the full  opera-\n"
"                             tion lasted. The time will be displayed with mil-\n"
"                             lisecond resolution.\n"
"\n"
"              url_effective  The URL that was fetched last. This is most mean-\n"
"                             ingful  if  you've  told curl to follow location:\n"
"                             headers.\n"
"\n"
, stdout);
 fputs(
"       If this option is used several times, the last one will be used.\n"
"\n"
"       -x, --proxy <[protocol://][user:password@]proxyhost[:port]>\n"
"              Use the specified HTTP proxy. If the port number is  not  speci-\n"
"              fied, it is assumed at port 1080.\n"
"\n"
"              This  option  overrides  existing environment variables that set\n"
"              the proxy to use. If there's an environment variable  setting  a\n"
"              proxy, you can set proxy to \"\" to override it.\n"
"\n"
, stdout);
 fputs(
"              All operations that are performed over an HTTP proxy will trans-\n"
"              parently be converted to HTTP. It means  that  certain  protocol\n"
"              specific operations might not be available. This is not the case\n"
"              if you can tunnel through the proxy, as one with the -p, --prox-\n"
"              ytunnel option.\n"
"\n"
"              User and password that might be provided in the proxy string are\n"
, stdout);
 fputs(
"              URL decoded by curl. This allows you to pass in special  charac-\n"
"              ters such as @ by using %40 or pass in a colon with %3a.\n"
"\n"
"              The  proxy host can be specified the exact same way as the proxy\n"
"              environment variables, including the protocol  prefix  (http://)\n"
"              and the embedded user + password.\n"
"\n"
"              From  7.21.7,  the  proxy  string may be specified with a proto-\n"
, stdout);
 fputs(
"              col://  prefix  to  specify  alternative  proxy  protocols.  Use\n"
"              socks4://,  socks4a://,  socks5://  or socks5h:// to request the\n"
"              specific SOCKS  version  to  be  used.  No  protocol  specified,\n"
"              http:// and all others will be treated as HTTP proxies.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -X, --request <command>\n"
"              (HTTP) Specifies a custom request method to use when communicat-\n"
, stdout);
 fputs(
"              ing with the HTTP server.  The specified request  will  be  used\n"
"              instead  of  the  method otherwise used (which defaults to GET).\n"
"              Read the HTTP 1.1 specification for  details  and  explanations.\n"
"              Common  additional  HTTP  requests  include  PUT and DELETE, but\n"
"              related technologies like WebDAV offers PROPFIND, COPY, MOVE and\n"
"              more.\n"
"\n"
"              Normally  you  don't  need  this option. All sorts of GET, HEAD,\n"
, stdout);
 fputs(
"              POST and PUT requests are rather invoked by using dedicated com-\n"
"              mand line options.\n"
"\n"
"              This  option  only  changes  the  actual  word  used in the HTTP\n"
"              request, it does not alter the way curl behaves. So for  example\n"
"              if  you  want  to make a proper HEAD request, using -X HEAD will\n"
"              not suffice. You need to use the -I, --head option.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead of LIST when\n"
, stdout);
 fputs(
"              doing file lists with FTP.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --xattr\n"
"              When  saving  output  to a file, this option tells curl to store\n"
"              certain file metadata in extened file attributes. Currently, the\n"
"              URL is stored in the xdg.origin.url attribute and, for HTTP, the\n"
"              content type is stored in the mime_type attribute. If  the  file\n"
, stdout);
 fputs(
"              system  does  not  support  extended  attributes,  a  warning is\n"
"              issued.\n"
"\n"
"       -y, --speed-time <time>\n"
"              If a download is slower than speed-limit bytes per second during\n"
"              a speed-time period, the download gets aborted. If speed-time is\n"
"              used, the default speed-limit will be 1 unless set with -Y.\n"
"\n"
"              This option controls transfers and thus  will  not  affect  slow\n"
, stdout);
 fputs(
"              connects  etc.  If this is a concern for you, try the --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -Y, --speed-limit <speed>\n"
"              If a download is slower than this given speed (in bytes per sec-\n"
"              ond)  for  speed-time seconds it gets aborted. speed-time is set\n"
"              with -y and is 30 if not set.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -z/--time-cond <date expression>|<file>\n"
"              (HTTP/FTP) Request a file that has been modified later than  the\n"
"              given  time  and date, or one that has been modified before that\n"
"              time. The <date expression> can be all sorts of date strings  or\n"
"              if it doesn't match any internal ones, it is taken as a filename\n"
, stdout);
 fputs(
"              and tries to get  the  modification  date  (mtime)  from  <file>\n"
"              instead.  See  the curl_getdate(3) man pages for date expression\n"
"              details.\n"
"\n"
"              Start the date expression with a dash (-) to make it request for\n"
"              a  document that is older than the given date/time, default is a\n"
"              document that is newer than the specified date/time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       -h, --help\n"
"              Usage help.\n"
"\n"
"       -M, --manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -V, --version\n"
"              Displays information about curl and the libcurl version it uses.\n"
"              The first line includes the full version of  curl,  libcurl  and\n"
"              other 3rd party libraries linked with the executable.\n"
"\n"
"              The  second  line (starts with \"Protocols:\") shows all protocols\n"
"              that libcurl reports to support.\n"
"\n"
, stdout);
 fputs(
"              The third line (starts with \"Features:\") shows specific features\n"
"              libcurl reports to offer. Available features include:\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for FTP is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic  decompression of compressed files over HTTP is\n"
"                     supported.\n"
"\n"
"              NTLM   NTLM authentication is supported.\n"
"\n"
"              GSS-Negotiate\n"
, stdout);
 fputs(
"                     Negotiate authentication and krb5 for FTP is supported.\n"
"\n"
"              Debug  This curl uses a libcurl built with Debug.  This  enables\n"
"                     more  error-tracking  and memory debugging etc. For curl-\n"
"                     developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authentication is supported.\n"
"\n"
"              Largefile\n"
, stdout);
 fputs(
"                     This curl supports transfers of large files, files larger\n"
"                     than 2GB.\n"
"\n"
"              IDN    This curl supports IDN - international domain names.\n"
"\n"
"              SSPI   SSPI  is  supported. If you use NTLM and set a blank user\n"
"                     name, curl will authenticate with your current  user  and\n"
"                     password.\n"
"\n"
"              TLS-SRP\n"
"                     SRP  (Secure Remote Password) authentication is supported\n"
, stdout);
 fputs(
"                     for TLS.\n"
"              Metalink\n"
"                     This curl supports Metalink (both version 3  and  4  (RFC\n"
"                     5854)),  which  describes  mirrors and hashes.  curl will\n"
"                     use mirrors for failover if there are errors (such as the\n"
"                     file or server not being available).\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file, see -K, --config for details.\n"
"\n"
"ENVIRONMENT\n"
, stdout);
 fputs(
"       The environment variables can be specified in lower case or upper case.\n"
"       The lower case version has precedence. http_proxy is an exception as it\n"
"       is only available in lower case.\n"
"\n"
"       Using  an  environment variable to set the proxy has the same effect as\n"
"       using the --proxy option.\n"
"\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets the proxy server to use for HTTP.\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets the proxy server to use for HTTPS.\n"
"\n"
"       [url-protocol]_PROXY [protocol://]<host>[:port]\n"
"              Sets the proxy server to use for [url-protocol], where the  pro-\n"
"              tocol  is  a  protocol  that curl supports and as specified in a\n"
"              URL. FTP, FTPS, POP3, IMAP, SMTP, LDAP etc.\n"
"\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
"              Sets the proxy server to use if no  protocol-specific  proxy  is\n"
"              set.\n"
"\n"
, stdout);
 fputs(
"       NO_PROXY <comma-separated list of hosts>\n"
"              list  of  host names that shouldn't go through any proxy. If set\n"
"              to a asterisk '*' only, it matches all hosts.\n"
"\n"
"PROXY PROTOCOL PREFIXES\n"
"       Since curl version 7.21.7, the proxy string may  be  specified  with  a\n"
"       protocol:// prefix to specify alternative proxy protocols.\n"
"\n"
"       If  no  protocol  is  specified  in  the  proxy string or if the string\n"
, stdout);
 fputs(
"       doesn't match a supported one, the proxy will be  treated  as  an  HTTP\n"
"       proxy.\n"
"\n"
"       The supported proxy protocol prefixes are as follows:\n"
"\n"
"       socks4://\n"
"              Makes it the equivalent of --socks4\n"
"\n"
"       socks4a://\n"
"              Makes it the equivalent of --socks4a\n"
"\n"
"       socks5://\n"
"              Makes it the equivalent of --socks5\n"
"\n"
"       socks5h://\n"
"              Makes it the equivalent of --socks5-hostname\n"
"\n"
"EXIT CODES\n"
, stdout);
 fputs(
"       There  are  a  bunch  of  different error codes and their corresponding\n"
"       error messages that may appear during bad conditions. At  the  time  of\n"
"       this writing, the exit codes are:\n"
"\n"
"       1      Unsupported protocol. This build of curl has no support for this\n"
"              protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformed. The syntax was not correct.\n"
"\n"
"       4      A feature or option that  was  needed  to  perform  the  desired\n"
, stdout);
 fputs(
"              request  was  not  enabled  or was explicitly disabled at build-\n"
"              time. To make curl able to do this, you  probably  need  another\n"
"              build of libcurl!\n"
"\n"
"       5      Couldn't  resolve  proxy.  The  given  proxy  host  could not be\n"
"              resolved.\n"
"\n"
"       6      Couldn't resolve host. The given remote host was not resolved.\n"
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply.  The  server  sent  data  curl  couldn't\n"
, stdout);
 fputs(
"              parse.\n"
"\n"
"       9      FTP  access  denied. The server denied login or denied access to\n"
"              the particular resource or directory you wanted to  reach.  Most\n"
"              often  you  tried to change to a directory that doesn't exist on\n"
"              the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply sent to  the\n"
"              PASS request.\n"
"\n"
"       13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the\n"
, stdout);
 fputs(
"              PASV request.\n"
"\n"
"       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the\n"
"              server sent.\n"
"\n"
"       15     FTP  can't  get host. Couldn't resolve the host IP we got in the\n"
"              227-line.\n"
"\n"
"       17     FTP couldn't set binary.  Couldn't  change  transfer  method  to\n"
"              binary.\n"
"\n"
"       18     Partial file. Only a part of the file was transferred.\n"
"\n"
"       19     FTP  couldn't download/access the given file, the RETR (or simi-\n"
, stdout);
 fputs(
"              lar) command failed.\n"
"\n"
"       21     FTP quote error. A quote command returned error from the server.\n"
"       22     HTTP page not retrieved. The requested  url  was  not  found  or\n"
"              returned  another  error  with  the HTTP error code being 400 or\n"
"              above. This return code only appears if -f, --fail is used.\n"
"\n"
"       23     Write error. Curl couldn't write data to a local  filesystem  or\n"
"              similar.\n"
"\n"
, stdout);
 fputs(
"       25     FTP  couldn't  STOR  file. The server denied the STOR operation,\n"
"              used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request failed.\n"
"\n"
"       28     Operation timeout. The specified  time-out  period  was  reached\n"
"              according to the conditions.\n"
"\n"
"       30     FTP  PORT  failed.  The PORT command failed. Not all FTP servers\n"
, stdout);
 fputs(
"              support the PORT  command,  try  doing  a  transfer  using  PASV\n"
"              instead!\n"
"\n"
"       31     FTP  couldn't use REST. The REST command failed. This command is\n"
"              used for resumed FTP transfers.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't work.\n"
"\n"
"       34     HTTP post error. Internal post-request generation error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
, stdout);
 fputs(
"       36     FTP bad download resume. Couldn't continue  an  earlier  aborted\n"
"              download.\n"
"\n"
"       37     FILE couldn't read file. Failed to open the file. Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
"       41     Function not found. A required LDAP function was not found.\n"
"\n"
"       42     Aborted by callback. An application told curl to abort the oper-\n"
"              ation.\n"
"\n"
, stdout);
 fputs(
"       43     Internal error. A function was called with a bad parameter.\n"
"\n"
"       45     Interface error. A specified outgoing  interface  could  not  be\n"
"              used.\n"
"\n"
"       47     Too many redirects. When following redirects, curl hit the maxi-\n"
"              mum amount.\n"
"\n"
"       48     Unknown option specified to libcurl.  This  indicates  that  you\n"
"              passed  a weird option to curl that was passed on to libcurl and\n"
"              rejected. Read up in the manual!\n"
"\n"
, stdout);
 fputs(
"       49     Malformed telnet option.\n"
"\n"
"       51     The peer's SSL certificate or SSH MD5 fingerprint was not OK.\n"
"\n"
"       52     The server didn't reply anything, which here  is  considered  an\n"
"              error.\n"
"\n"
"       53     SSL crypto engine not found.\n"
"\n"
"       54     Cannot set SSL crypto engine as default.\n"
"\n"
"       55     Failed sending network data.\n"
"\n"
"       56     Failure in receiving network data.\n"
"\n"
"       58     Problem with the local certificate.\n"
"\n"
, stdout);
 fputs(
"       59     Couldn't use specified SSL cipher.\n"
"\n"
"       60     Peer  certificate cannot be authenticated with known CA certifi-\n"
"              cates.\n"
"\n"
"       61     Unrecognized transfer encoding.\n"
"\n"
"       62     Invalid LDAP URL.\n"
"\n"
"       63     Maximum file size exceeded.\n"
"\n"
"       64     Requested FTP SSL level failed.\n"
"\n"
"       65     Sending the data requires a rewind that failed.\n"
"\n"
"       66     Failed to initialise SSL Engine.\n"
"\n"
, stdout);
 fputs(
"       67     The user name, password, or similar was not  accepted  and  curl\n"
"              failed to log in.\n"
"\n"
"       68     File not found on TFTP server.\n"
"\n"
"       69     Permission problem on TFTP server.\n"
"\n"
"       70     Out of disk space on TFTP server.\n"
"\n"
"       71     Illegal TFTP operation.\n"
"\n"
"       72     Unknown TFTP transfer ID.\n"
"\n"
"       73     File already exists (TFTP).\n"
"\n"
"       74     No such user (TFTP).\n"
"\n"
"       75     Character conversion failed.\n"
"\n"
, stdout);
 fputs(
"       76     Character conversion functions required.\n"
"\n"
"       77     Problem with reading the SSL CA cert (path? access rights?).\n"
"\n"
"       78     The resource referenced in the URL does not exist.\n"
"\n"
"       79     An unspecified error occurred during the SSH session.\n"
"\n"
"       80     Failed to shut down the SSL connection.\n"
"\n"
"       82     Could  not  load  CRL  file,  missing  or wrong format (added in\n"
"              7.19.0).\n"
"\n"
"       83     Issuer check failed (added in 7.19.0).\n"
"\n"
, stdout);
 fputs(
"       84     The FTP PRET command failed\n"
"\n"
"       85     RTSP: mismatch of CSeq numbers\n"
"\n"
"       86     RTSP: mismatch of Session Identifiers\n"
"\n"
"       87     unable to parse FTP file list\n"
"\n"
"       88     FTP chunk callback reported error\n"
"\n"
"       XX     More error codes will appear here in future releases. The exist-\n"
"              ing ones are meant to never change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel  Stenberg is the main author, but the whole list of contributors\n"
, stdout);
 fputs(
"       is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from Netscape's web-server:\n"
"\n"
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
, stdout);
 fputs(
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a directory listing of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"  Get a file off an FTPS server:\n"
"\n"
"        curl ftps://files.are.secure.com/secrets.txt\n"
"\n"
, stdout);
 fputs(
"  or use the more appropriate FTPS way to get the same file:\n"
"\n"
"        curl --ftp-ssl ftp://files.are.secure.com/secrets.txt\n"
"\n"
"  Get a file from an SSH server using SFTP:\n"
"\n"
"        curl -u username sftp://shell.example.com/etc/issue\n"
"\n"
"  Get a file from an SSH server using SCP using a private key to authenticate:\n"
"\n"
"        curl -u username: --key ~/.ssh/id_dsa --pubkey ~/.ssh/id_dsa.pub \\\n"
"            scp://shell.example.com/~/personal.txt\n"
"\n"
"  Get the main page from an IPv6 web server:\n"
"\n"
, stdout);
 fputs(
"        curl -g \"http://[2001:1890:1112:1::20]/\"\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file with a specific name:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
, stdout);
 fputs(
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
"   It is just like for FTP, but you may also want to specify and use\n"
"   SSL-specific options for certificates etc.\n"
"\n"
, stdout);
 fputs(
"   Note that using FTPS:// as prefix is the \"implicit\" way as described in the\n"
"   standards while the recommended \"explicit\" way is done by using FTP:// and\n"
"   the --ftp-ssl option.\n"
"\n"
" SFTP / SCP\n"
"\n"
"   This is similar to FTP, but you can specify a private key to use instead of\n"
"   a password. Note that the private key may itself be protected by a password\n"
"   that is unrelated to the login password of the remote system.  If you\n"
"   provide a private key file you must also provide a public key file.\n"
, stdout);
 fputs(
"\n"
" HTTP\n"
"\n"
"   Curl also supports user and password in HTTP URLs, thus you can pick a file\n"
"   like:\n"
"\n"
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   HTTP offers many different methods of authentication and curl supports\n"
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
, stdout);
 fputs(
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
"   --anyauth.\n"
"\n"
"   NOTE! According to the URL specification, HTTP URLs can not contain a user\n"
"   and password, so that style will not work when using curl via a proxy, even\n"
"   though curl allows it at other times. When using a proxy, you _must_ use\n"
"   the -u style for user and password.\n"
"\n"
" HTTPS\n"
"\n"
, stdout);
 fputs(
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
"PROXY\n"
"\n"
" curl supports both HTTP and SOCKS proxy servers, with optional authentication.\n"
" It does not have special support for FTP proxy servers since there are no\n"
" standards for those, but it can still be made to work with many of them. You\n"
" can also use both HTTP and SOCKS proxies to transfer files to and from FTP\n"
" servers.\n"
"\n"
" Get an ftp file using an HTTP proxy named my-proxy that uses port 888:\n"
"\n"
, stdout);
 fputs(
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from an HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" A comma-separated list of hosts and domains which do not use the proxy can\n"
" be specified as:\n"
"\n"
, stdout);
 fputs(
"        curl --noproxy localhost,get.this -x my-proxy:888 http://www.get.this/\n"
"\n"
" If the proxy is specified with --proxy1.0 instead of --proxy or -x, then\n"
" curl will use HTTP/1.0 instead of HTTP/1.1 for any CONNECT attempts.\n"
"\n"
" curl also supports SOCKS4 and SOCKS5 proxies with --socks4 and --socks5.\n"
"\n"
" See also the environment variables Curl supports that offer further proxy\n"
" control.\n"
"\n"
" Most FTP proxy servers are set up to appear as a normal FTP server from the\n"
, stdout);
 fputs(
" client's perspective, with special commands to select the remote FTP server.\n"
" curl supports the -u, -Q and --ftp-account options that can be used to\n"
" set up transfers through many FTP proxies. For example, a file can be\n"
" uploaded to a remote FTP server using a Blue Coat FTP proxy with the\n"
" options:\n"
"\n"
"   curl -u \"Remote-FTP-Username@remote.ftp.server Proxy-Username:Remote-Pass\" \\\n"
"    --ftp-account Proxy-Password --upload-file local-file \\\n"
"    ftp://my-ftp.proxy.server:21/remote/upload/path/\n"
"\n"
, stdout);
 fputs(
" See the manual for your FTP proxy to determine the form it expects to set up\n"
" transfers, and curl's -v option to see exactly what curl is sending.\n"
"\n"
"RANGES\n"
"\n"
"  HTTP 1.1 introduced byte-ranges. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README\n"
"\n"
"UPLOADING\n"
"\n"
" FTP / FTPS / SFTP / SCP\n"
"\n"
"  Upload all data on stdin to a specified server:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
, stdout);
 fputs(
"  Upload a local file to the remote site, and use the local file name at the remote\n"
"  site too:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file:\n"
"\n"
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
, stdout);
 fputs(
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified HTTP site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the HTTP server must have been configured to accept PUT before\n"
"  this can be done successfully.\n"
"\n"
"  For other ways to do HTTP data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
, stdout);
 fputs(
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
"\n"
"\n"
, stdout);
 fputs(
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
, stdout);
 fputs(
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
, stdout);
 fputs(
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
, stdout);
 fputs(
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  replace weird letters with %XX where XX is the hexadecimal representation of\n"
, stdout);
 fputs(
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
, stdout);
 fputs(
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
, stdout);
 fputs(
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
, stdout);
 fputs(
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
"  use the default type 'application/octet-stream'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
, stdout);
 fputs(
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
, stdout);
 fputs(
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
"\n"
"        curl -F \"pictures=@dog.gif,cat.gif\"\n"
"\n"
"  2. Send two fields with two field names:\n"
"\n"
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\"\n"
"\n"
"  To send a field value literally without interpreting a leading '@'\n"
"  or '<', or an embedded ';type=', use --form-string instead of\n"
, stdout);
 fputs(
"  -F. This is recommended when the value is obtained from a user or\n"
"  some other unpredictable source. Under these circumstances, using\n"
"  -F instead of --form-string would allow a user to trick curl into\n"
"  uploading a file.\n"
"\n"
"REFERRER\n"
"\n"
"  An HTTP request has the option to include information about which address\n"
"  referred it to the actual page.  Curl allows you to specify the\n"
"  referrer to be used on the command line. It is especially useful to\n"
, stdout);
 fputs(
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The Referer: [sic] field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
"  An HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
, stdout);
 fputs(
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
, stdout);
 fputs(
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
"  client's side. The server sets cookies by sending a response line in the\n"
, stdout);
 fputs(
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
, stdout);
 fputs(
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
, stdout);
 fputs(
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
"  While saving headers to a file is a working way to store cookies, it is\n"
"  however error-prone and not the preferred way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
, stdout);
 fputs(
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
, stdout);
 fputs(
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a nonexistent file.\n"
"\n"
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
, stdout);
 fputs(
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
, stdout);
 fputs(
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
"   %             - percentage completed of the upload\n"
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
, stdout);
 fputs(
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
, stdout);
 fputs(
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
, stdout);
 fputs(
"  that the above operation must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwidth throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
, stdout);
 fputs(
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
, stdout);
 fputs(
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
, stdout);
 fputs(
"  line is a '#'-symbol the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must enclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
, stdout);
 fputs(
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
, stdout);
 fputs(
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
, stdout);
 fputs(
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
, stdout);
 fputs(
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
, stdout);
 fputs(
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"SFTP and SCP and PATH NAMES\n"
"\n"
"  With sftp: and scp: URLs, the path name given is the absolute name on the\n"
"  server. To access a file relative to the remote user's home directory,\n"
"  prefix the file with /~/ , such as:\n"
"\n"
"        curl -u $USER sftp://home.example.com/~/.bashrc\n"
"\n"
"FTP and firewalls\n"
"\n"
, stdout);
 fputs(
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connection as soon as data is about to get transferred. There are two ways to\n"
"  do this.\n"
"\n"
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that doesn't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  If the server, for example, is behind a firewall that doesn't allow connections\n"
"  on ports other than 21 (or if it just doesn't support the PASV command), the\n"
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given IP number and port (as parameters to the\n"
"  PORT command).\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
, stdout);
 fputs(
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
, stdout);
 fputs(
"        curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"        curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS protocol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
, stdout);
 fputs(
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
, stdout);
 fputs(
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
, stdout);
 fputs(
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, which newer versions\n"
"  of OpenSSL etc use, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
, stdout);
 fputs(
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this:\n"
"\n"
"    In Netscape, you start with hitting the 'Security' menu button.\n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list\n"
"\n"
"    Press the 'Export' button\n"
"\n"
"    enter your PIN code for the certs\n"
"\n"
"    select a proper place to save it\n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"    In Firefox, select Options, then Advanced, then the Encryption tab,\n"
"    View Certificates. This opens the Certificate Manager, where you can\n"
"    Export. Be sure to select PEM for the Save as type.\n"
"\n"
"    In Internet Explorer, select Internet Options, then the Content tab, then\n"
, stdout);
 fputs(
"    Certificates. Then you can Export, and depending on the format you may\n"
"    need to convert to PEM.\n"
"\n"
"    In Chrome, select Settings, then Show Advanced Settings. Under HTTPS/SSL\n"
"    select Manage Certificates.\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on HTTP(S) downloads as well as FTP uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
, stdout);
 fputs(
" Continue uploading a document(*1):\n"
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the FTP server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
, stdout);
 fputs(
" HTTP allows a client to specify a time condition for the document it\n"
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allows you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
, stdout);
 fputs(
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since January 12, 2012:\n"
"\n"
"        curl -z \"Jan 12 2012\" http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
, stdout);
 fputs(
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
, stdout);
 fputs(
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advise you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
, stdout);
 fputs(
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
"  RFC 2255, \"The LDAP URL Format\" http://curl.haxx.se/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is how I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
, stdout);
 fputs(
"  Curl reads and understands the following environment variables:\n"
"\n"
"        http_proxy, HTTPS_PROXY, FTP_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"\n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If the host name matches one of these strings, or the host is within the\n"
, stdout);
 fputs(
"  domain of one of these strings, transactions with that node will not be\n"
"  proxied.\n"
"\n"
"\n"
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited FTP sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
, stdout);
 fputs(
"  passwords, so therefore most unix programs won't read this file unless it is\n"
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told to (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to just FTP,\n"
"  so curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
, stdout);
 fputs(
"  To better allow script programmers to get to know about the progress of\n"
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 and kerberos5/GSSAPI for FTP transfers. You need\n"
, stdout);
 fputs(
"  the kerberos package installed and used at curl build time for it to be\n"
"  available.\n"
"\n"
"  First, get the krb-ticket the normal way, like with the kinit/kauth tool.\n"
"  Then use curl in way similar to:\n"
"\n"
"        curl --krb private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kinit/kauth.\n"
"\n"
"TELNET\n"
"\n"
, stdout);
 fputs(
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
, stdout);
 fputs(
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: The telnet protocol does not specify any way to login with a specified\n"
, stdout);
 fputs(
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTENT CONNECTIONS\n"
"\n"
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistent connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
, stdout);
 fputs(
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
"  Note that curl cannot use persistent connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use an HTTP proxy for file transfers, practically\n"
, stdout);
 fputs(
"  all transfers will be persistent.\n"
"\n"
"MULTIPLE TRANSFERS WITH A SINGLE COMMAND LINE\n"
"\n"
"  As is mentioned above, you can download multiple files with one command line\n"
"  by simply adding more URLs. If you want those to get saved to a local file\n"
"  instead of just printed to stdout, you need to add one save option for each\n"
"  URL you specify. Note that this also goes for the -O option (but not\n"
"  --remote-name-all).\n"
"\n"
"  For example: get two files and use -O for the first and a custom file\n"
, stdout);
 fputs(
"  name for the second:\n"
"\n"
"    curl -O http://url.com/file.txt ftp://ftp.com/moo.exe -o moo.jpg\n"
"\n"
"  You can also upload multiple files in a similar fashion:\n"
"\n"
"    curl -T local1 ftp://ftp.com/moo.exe -T local2 ftp://ftp.com/moo2.txt\n"
"\n"
"IPv6\n"
"\n"
"  curl will connect to a server with IPv6 when a host lookup returns an IPv6\n"
"  address and fall back to IPv4 if the connection fails. The --ipv4 and --ipv6\n"
"  options can specify which address to use when both are available. IPv6\n"
, stdout);
 fputs(
"  addresses can also be specified directly in URLs using the syntax:\n"
"\n"
"    http://[2001:1890:1112:1::20]/overview.html\n"
"\n"
"  When this style is used, the -g option must be given to stop curl from\n"
"  interpreting the square brackets as special globbing characters.  Link local\n"
"  and site local addresses including a scope identifier, such as fe80::1234%1,\n"
"  may also be used, but the scope portion must be numeric and the percent\n"
"  character must be URL escaped. The previous example in an SFTP URL might\n"
, stdout);
 fputs(
"  look like:\n"
"\n"
"    sftp://[fe80::1234%251]/\n"
"\n"
"  IPv6 addresses provided other than in URLs (e.g. to the --proxy, --interface\n"
"  or --ftp-port options) should not be URL encoded.\n"
"\n"
"METALINK\n"
"\n"
"  Curl supports Metalink (both version 3 and 4 (RFC 5854) are supported), a way\n"
"  to list multiple URIs and hashes for a file. Curl will make use of the mirrors\n"
"  listed within for failover if there are errors (such as the file or server not\n"
, stdout);
 fputs(
"  being available). It will also verify the hash of the file after the download\n"
"  completes. The Metalink file itself is downloaded and processed in memory and\n"
"  not stored in the local file system.\n"
"\n"
"  Example to use a remote Metalink file:\n"
"\n"
"    curl --metalink http://www.example.com/example.metalink\n"
"\n"
"  To use a Metalink file in the local file system, use FILE protocol (file://):\n"
"\n"
"    curl --metalink file://example.metalink\n"
"\n"
, stdout);
 fputs(
"  Please note that if FILE protocol is disabled, there is no way to use a local\n"
"  Metalink file at the time of this writing. Also note that if --metalink and\n"
"  --include are used together, --include will be ignored. This is because including\n"
"  headers in the response will break Metalink parser and if the headers are included\n"
"  in the file described in Metalink file, hash check will fail.\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
, stdout);
 fputs(
"  its development and things relevant to this. Get all info at\n"
"  http://curl.haxx.se/mail/. Some of the lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
, stdout);
 fputs(
"    Low-traffic. Only receives announcements of new public versions. At worst,\n"
"    that makes something like one or two mails per month, but usually only one\n"
"    mail every second month.\n"
"\n"
"  curl-and-php\n"
"\n"
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-and-python\n"
"\n"
"    Python hackers using curl with or without the python binding pycurl.\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
, stdout);
 fputs(
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
